% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_sih.R
\name{process_sih}
\alias{process_sih}
\title{Process SIH variables from DataSUS}
\usage{
process_sih(data, information_system = "SIH-RD", municipality_data = TRUE)
}
\arguments{
\item{data}{\code{data.frame} created by \code{fetch_datasus()}.}

\item{information_system}{string. The abbreviation of the health information system. See \emph{Details}.}

\item{municipality_data}{optional logical. \code{TRUE} by default, creates new variables in the dataset informing the full name and other details about the municipality of residence.}
}
\value{
a \code{data.frame} with the processed data.
}
\description{
\code{process_SIH} processes SIH variables retrieved by \code{fetch_datasus()}.
}
\details{
This function processes SIH variables retrieved by \code{fetch_datasus()}, informing labels for categoric variables including NA values.

Currently, only "SIH-RD" is supported.
}
\examples{
process_sih(sih_rd_sample)

}
