% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_wrap_n.R
\name{str_wrap_n}
\alias{str_wrap_n}
\title{Wrap character string to fit a target number of lines}
\usage{
str_wrap_n(string = NULL, n = 2)
}
\arguments{
\item{string}{Character string to be broken up}

\item{n}{Number of lines to break the string over}
}
\value{
The original \code{string} with line breaks inserted at optimal positions.
}
\description{
Inserts line breaks for spaces, where the position of the line breaks are chosen to provide the most balanced length of each line.
}
\details{
Function is intended for a small number of line breaks. The \code{n} argument is not allowed to be greater than 8 as all combinations of possible line breaks are explored.

When there a number of possible solutions that provide equally balanced number of characters in each line, the function returns the character string where the number of spaces are distributed most evenly.
}
\examples{
str_wrap_n(string = "a bb ccc dddd eeee ffffff", n = 2)
str_wrap_n(string = "a bb ccc dddd eeee ffffff", n = 4)
str_wrap_n(string = "a bb ccc dddd eeee ffffff", n = 8)
str_wrap_n(string = c("a bb", "a bb ccc"), n = 2)
}
