% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_nodes.R
\name{mark_nodes}
\alias{mark_nodes}
\alias{node_is_cutpoint}
\alias{node_is_isolate}
\alias{node_is_max}
\alias{node_is_min}
\title{Marking nodes based on their properties}
\usage{
node_is_cutpoint(object)

node_is_isolate(object)

node_is_max(node_measure)

node_is_min(node_measure)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{node_measure}{An object created by a \code{node_} measure.}
}
\description{
These functions return logical vectors the length of the
nodes in a network identifying which hold certain properties.

\code{node_is_cutpoint()} and \code{node_is_isolate()} are useful for identifying
nodes that are in particular positions in the network.
More can be added here.

\code{node_is_max()} and \code{node_is_min()} are more generally useful
for converting the results from some node measure into a mark-class object.
They can be particularly useful for highlighting which node or nodes
are key because they minimise or, more often, maximise some measure.
}
\section{Functions}{
\itemize{
\item \code{node_is_cutpoint}: Returns logical of which nodes cut
or act as articulation points in a network,
increasing the number of connected components in a graph when removed.

\item \code{node_is_isolate}: Returns logical of which nodes are isolates,
with neither incoming nor outgoing ties.

\item \code{node_is_max}: Returns logical of which nodes
hold the maximum of some measure

\item \code{node_is_min}: Returns logical of which nodes
hold the minimum of some measure
}}

\examples{
node_is_cutpoint(ison_brandes)
node_is_isolate(ison_brandes)
node_is_max(node_degree(ison_brandes))
node_is_min(node_degree(ison_brandes))
}
\seealso{
Other marks: 
\code{\link{is}()},
\code{\link{mark_ties}}
}
\concept{marks}
