% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\alias{generate_random}
\alias{generate_smallworld}
\alias{generate_scalefree}
\alias{generate_permutation}
\title{Create networks from particular probabilities}
\usage{
generate_random(n, p = 0.5, directed = FALSE)

generate_smallworld(n, p = 0.05)

generate_scalefree(n, p = 1)

generate_permutation(object, with_attr = TRUE)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A migraph-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Proportion of possible edges in the network that are realised or,
if integer greater than 1, the number of edges in the network.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{object}{a migraph-consistent object}

\item{with_attr}{Logical. Whether any attributes of the object
should be retained. By default TRUE.}
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some random element. They are particularly useful for
creating a distribution of networks for exploring or testing
network properties.
}
\section{Functions}{
\itemize{
\item \code{generate_random}: Generates a random network with a particular probability.

\item \code{generate_smallworld}: Generates a small-world structure
following the lattice rewiring model.

\item \code{generate_scalefree}: Generates a scale-free structure
following the preferential attachment model.

\item \code{generate_permutation}: Generates a permutation of the original network
using a Fisher-Yates shuffle on both the rows and columns (for a one-mode network)
or on each of the rows and columns (for a two-mode network).
}}

\examples{
autographr(generate_random(12, 0.4)) +
autographr(generate_random(c(6, 6), 0.4))
autographr(generate_smallworld(12, 0.025)) +
autographr(generate_smallworld(12, 0.25))
autographr(generate_scalefree(12, 0.25)) +
autographr(generate_scalefree(12, 1.25))
autographr(mpn_elite_usa_advice) +
autographr(generate_permutation(mpn_elite_usa_advice))
}
\seealso{
Other creation: 
\code{\link{create}}
}
\concept{creation}
