% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_play.R
\name{play}
\alias{play}
\alias{play_diffusion}
\alias{play_diffusions}
\alias{play_learning}
\alias{play_segregation}
\title{Functions to play games on networks}
\usage{
play_diffusion(
  .data,
  seeds = 1,
  thresholds = 1,
  transmissibility = 1,
  latency = 0,
  recovery = 0,
  waning = 0,
  immune = NULL,
  steps
)

play_diffusions(
  .data,
  seeds = 1,
  thresholds = 1,
  transmissibility = 1,
  latency = 0,
  recovery = 0,
  waning = 0,
  immune = NULL,
  steps,
  times = 5,
  strategy = "sequential",
  verbose = FALSE
)

play_learning(.data, beliefs, steps, epsilon = 5e-04)

play_segregation(
  .data,
  attribute,
  heterophily = 0,
  who_moves = c("ordered", "random", "most_dissatisfied"),
  choice_function = c("satisficing", "optimising"),
  steps
)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{seeds}{A valid mark vector the length of the
number of nodes in the network.}

\item{thresholds}{A numeric vector indicating the thresholds
each node has. By default 1.
A single number means a generic threshold;
for thresholds that vary among the population please use a vector
the length of the number of nodes in the network.
If 1 or larger, the threshold is interpreted as a simple count
of the number of contacts/exposures sufficient for infection.
If less than 1, the threshold is interpreted as complex,
where the threshold concerns the proportion of contacts.}

\item{transmissibility}{A proportion indicating the transmission rate,
\eqn{\beta}.
By default 1, which means any node for which the threshold is met
or exceeded will become infected.
Anything lower means a correspondingly lower probability of adoption,
even when the threshold is met or exceeded.}

\item{latency}{A proportion indicating the rate at which those exposed
become infectious (infected), \eqn{\sigma}.
For example, if exposed individuals take, on average,
four days to become infectious, then \eqn{\sigma = 0.25}.
By default 0, which means those exposed become immediately infectious (i.e. an SI model).
Anything higher results in e.g. a SEI model.}

\item{recovery}{A proportion indicating the rate of recovery,
\eqn{\gamma}.
For example, if infected individuals take, on average,
four days to recover, then \eqn{\gamma = 0.25}.
By default 0, which means there is no recovery (i.e. an SI model).
Anything higher results in an SIR model.}

\item{waning}{A proportion indicating the rate at which those who are
recovered become susceptible again, \eqn{\xi}.
For example, if recovered individuals take, on average,
four days to lose their immunity, then \eqn{\xi = 0.25}.
By default 0, which means any recovered individuals retain lifelong immunity (i.e. an SIR model).
Anything higher results in e.g. a SIRS model.
\eqn{\xi = 1} would mean there is no period of immunity, e.g. an SIS model.}

\item{immune}{A logical or numeric vector identifying nodes
that begin the diffusion process as already recovered.
This could be interpreted as those who are vaccinated or equivalent.
Note however that a waning parameter will affect these nodes too.
By default NULL, indicating that no nodes begin immune.}

\item{steps}{The number of steps forward in the diffusion to play.
By default the number of nodes in the network.
If \code{steps = Inf} then the diffusion process will continue until
there are no new infections or all nodes are infected.}

\item{times}{Integer indicating number of simulations used for quantile estimation.
(Relevant to the null hypothesis test only -
the analysis itself is unaffected by this parameter.)
Note that, as for all Monte Carlo procedures, convergence is slower for more
extreme quantiles.
By default, \code{times=1000}.
1,000 - 10,000 repetitions recommended for publication-ready results.}

\item{strategy}{If \code{{furrr}} is installed,
then multiple cores can be used to accelerate the function.
By default \code{"sequential"},
but if multiple cores available,
then \code{"multisession"} or \code{"multicore"} may be useful.
Generally this is useful only when \code{times} > 1000.
See \href{https://furrr.futureverse.org}{\code{{furrr}}} for more.}

\item{verbose}{Whether the function should report on its progress.
By default FALSE.
See \href{https://progressr.futureverse.org}{\code{{progressr}}} for more.}

\item{beliefs}{A vector indicating the probabilities nodes
put on some outcome being 'true'.}

\item{epsilon}{The maximum difference in beliefs accepted
for convergence to a consensus.}

\item{attribute}{A string naming some nodal attribute in the network.
Currently only tested for binary attributes.}

\item{heterophily}{A score ranging between -1 and 1 as a threshold for
how heterophilous nodes will accept their neighbours to be.
A single proportion means this threshold is shared by all nodes,
but it can also be a vector the same length of the nodes in the network
for issuing different thresholds to different nodes.
By default this is 0, meaning nodes will be dissatisfied if more than half
of their neighbours differ on the given attribute.}

\item{who_moves}{One of the following options:
"ordered" (the default) checks each node in turn for whether they are
dissatisfied and there is an available space that they can move to,
"random" will check a node at random,
and "most_dissatisfied" will check (one of) the most dissatisfied nodes first.}

\item{choice_function}{One of the following options:
"satisficing" (the default) will move the node to any coordinates that satisfy
their heterophily threshold,
whereas "optimising" will move the node to coordinates that are most homophilous.}
}
\description{
Functions to play games on networks
}
\section{Functions}{
\itemize{
\item \code{play_diffusion()}: Playing compartmental diffusion on networks.

\item \code{play_diffusions()}: Playing multiple compartmental diffusions on networks.

\item \code{play_learning()}: Playing DeGroot learning on networks.

\item \code{play_segregation()}: Playing Schelling segregation on networks.

}}
\examples{
  smeg <- manynet::generate_smallworld(15, 0.025)
  plot(play_diffusion(smeg))
  plot(play_diffusion(smeg, recovery = 0.4))
  plot(play_diffusions(smeg, times = 20))
  play_learning(ison_networkers, 
      rbinom(manynet::network_nodes(ison_networkers),1,prob = 0.25))
  startValues <- rbinom(100,1,prob = 0.5)
  startValues[sample(seq_len(100), round(100*0.2))] <- NA
  latticeEg <- manynet::create_lattice(100)
  latticeEg <- manynet::add_node_attribute(latticeEg, "startValues", startValues)
  latticeEg
  play_segregation(latticeEg, "startValues", 0.5)
  #manynet::autographr(latticeEg, node_color = "startValues", node_size = 5)
  #manynet::autographr(play_segregation(latticeEg, "startValues", 0.5), 
  #                    node_color = "startValues", node_size = 5)
}
\seealso{
Other models: 
\code{\link{regression}},
\code{\link{tests}}
}
\concept{models}
