% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{mm2md}
\alias{mm2md}
\title{Convert FreeMind mind map code into Markdown headings}
\usage{
mm2md(from = NA)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}
}
\value{
Character, showing outline in Markdown syntax.
}
\description{
Convert FreeMind mind map code into Markdown headings
}
\examples{
input <- system.file("examples/mindr-mm.mm", package = "mindr")
input_txt <- readLines(input, encoding = "UTF-8")
output_txt <- mm2md(input_txt)
output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
writeLines(output_txt, output, useBytes = TRUE)
# file.show(input) # Open the input file file.show(output) # Open the output
# file
message("Input:  ", input, "\nOutput: ", output)
# file.remove(output) # remove the output file
}
