% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isValidSyntax.R
\name{isValidSyntax}
\alias{isValidSyntax}
\title{Evaluate if a stoichiometric reaction has a valid syntax}
\usage{
isValidSyntax(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following format: 

\code{"H2O[c] + Urea-1-carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]"} 

Where arrows and plus signs are surrounded by a "space character".
It is also expected that stoichiometry coefficients are surrounded by spaces, (nothe the "2" before the CO2[c] or the NH3[c]).
It also expects arrows to be in the form "\code{=>}" or "\code{<=>}". 
Meaning that arrows like "\code{==>}", "\code{<==>}", "\code{-->}" or "\code{->}" will not be parsed and will lead to errors.}
}
\value{
A boolean value 'TRUE' if reaction has a valid syntax.
}
\description{
For a set of given stoichiometric reactions, this function makes the following syntactic evaluations for each reaction: \itemize{
\item Evaluates if the reaction contain more than one coefficient by metabolite
\item Evaluates if the reaction contain metabolite coefficients between parenthesis
\item Evaluates if the reaction contain arrow symbol between spaces
\item Evaluates if the reaction contain not allowed arrow symbols
\item Evaluates if the reaction contain metabolites name separated by a plus symbol between spaces
\item Evaluates if the reaction contain substituents separated of the metabolite names
}
}
\examples{
# Loading a CSV file
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))

# Data structure
head(glycolysis)

# Evaluating syntax
isValidSyntax(
 reactionList = glycolysis$REACTION
)
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}

