% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/characterizeReactions.R
\name{characterizeReactions}
\alias{characterizeReactions}
\title{Characterize stoichiometric reactions by compartments and reaction type}
\usage{
characterizeReactions(reactionList, rawOutput = FALSE)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}}

\item{rawOutput}{A boolean value \code{'TRUE'} or \code{'FALSE'} if raw data should be returned instead of computed values.}
}
\description{
For a given set of stoichiometric reactions, this function: \itemize{
\item Counts the number of reactions, 
\item Computes the relative frequency of each reaction type (transport, exchange and compartmentalized), 
\item Computes the relative frequency of reactions by compartment, 
\item Counts the number of unique metabolites, 
\item Computes the relative frequency of metabolites by compartment.
}
}
\examples{
# Loading a set of stoichiometric reactions
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep='\t')

# Characterizing the reactions
characterizeReactions(reactionList = glycolysis$REACTION)
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
