% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai}
\alias{as.promise.mirai}
\title{Make Mirai Promise}
\usage{
\method{as.promise}{mirai}(x)
}
\arguments{
\item{x}{an object of class 'mirai'.}
}
\value{
A 'promise' object.
}
\description{
Creates a 'promise' from a 'mirai'.
}
\details{
This function is an S3 method for the generic \code{as.promise} for
    class 'mirai'.

    Requires the packages \CRANpkg{promises} and \CRANpkg{later}.

    Allows a 'mirai' to be used with the promise pipe \code{\%...>\%}, which
    schedules a function to run upon resolution of the 'mirai'.
}
\examples{
if (interactive() &&
  requireNamespace("promises", quietly = TRUE) &&
  requireNamespace("later", quietly = TRUE)) {

library(promises)

p <- as.promise(mirai("example"))
print(p)
is.promise(p)

p2 <- mirai("completed") \%...>\% identity()
p2$then(cat)
is.promise(p2)

}

}
