% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{daemons}
\alias{daemons}
\title{daemons (Background Processes)}
\usage{
daemons(...)
}
\arguments{
\item{...}{either an integer to set the number of daemons, or 'view' to view
the number of currently active daemons.}
}
\value{
Depending on the specified \code{...} parameter:
    \itemize{
    \item{integer: integer change in number of daemons (created or destroyed).}
    \item{'view': integer number of currently set daemons.}
    \item{missing: the 'nanoSocket' for connecting to the daemons, or NULL if
    it is yet to be created.}
    }
}
\description{
Set or view the number of daemons (background processes). Create persistent
    background processes to receive \code{\link{mirai}} requests. This
    provides a potentially more efficient solution for async operations as
    new processes no longer need to be created on an ad hoc basis.
}
\details{
\{mirai\} will revert to the default behaviour of creating a new
    background process for each request if the number of daemons is set to 0.

    The current implementation is low-level and ensures tasks are
    evenly-distributed amongst daemons without actively managing a task queue.
    This approach provides a robust and resource-light solution, particularly
    well-suited to working with similar-length tasks, or where the number of
    concurrent tasks typically does not exceed the number of available
    daemons.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# Create 4 daemons
daemons(4)
# View the number of active daemons
daemons("view")
# Reset to zero
daemons(0)
}

}
