% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{unresolved}
\alias{unresolved}
\title{Query if a mirai is Unresolved}
\usage{
unresolved(aio)
}
\arguments{
\item{aio}{a \sQuote{mirai} object or \sQuote{mirai} value stored at
\code{$data}.}
}
\value{
Logical TRUE if \sQuote{aio} is an unresolved \sQuote{mirai} or
    \sQuote{mirai} value, or FALSE otherwise.
}
\description{
Query whether a \sQuote{mirai} or \sQuote{mirai} value remains unresolved.
    Unlike \code{\link{call_mirai}}, this function does not wait for
    completion.
}
\details{
Suitable for use in control flow statements such as \code{while} or
    \code{if}.

    Note: querying resolution may cause a previously unresolved
    \sQuote{mirai} to resolve.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(Sys.sleep(0.1))
unresolved(m)
Sys.sleep(0.3)
unresolved(m)

}

}
