% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{daemons}
\alias{daemons}
\title{Daemons (Set Persistent Processes)}
\usage{
daemons(
  n,
  url = NULL,
  remote = NULL,
  dispatcher = TRUE,
  ...,
  force = TRUE,
  seed = NULL,
  serial = NULL,
  tls = NULL,
  pass = NULL,
  .compute = "default"
)
}
\arguments{
\item{n}{integer number of daemons to launch.}

\item{url}{[default NULL] if specified, a character string comprising a URL
at which to listen for remote daemons, including a port accepting incoming
connections, e.g. 'tcp://hostname:5555' or 'tcp://10.75.32.70:5555'.
Specify a URL with scheme 'tls+tcp://' to use secure TLS connections (for
details see Distributed Computing section below). Auxiliary function
\code{\link{host_url}} may be used to construct a valid host URL.}

\item{remote}{[default NULL] required only for launching remote daemons, a
configuration generated by \code{\link{remote_config}} or
\code{\link{ssh_config}}.}

\item{dispatcher}{[default TRUE] logical value, whether to use dispatcher.
Dispatcher runs in a separate process to ensure optimal scheduling,
although this may not always be required (for details see Dispatcher
section below).}

\item{...}{(optional) additional arguments passed through to
\code{\link{daemon}} if launching daemons. These include \sQuote{asyncdial},
\sQuote{autoexit}, \sQuote{cleanup}, \sQuote{output}, \sQuote{maxtasks},
\sQuote{idletime} and \sQuote{walltime}.}

\item{force}{[default TRUE] logical value whether to always reset daemons and
apply new settings for a compute profile, even if already set. If FALSE,
applying new settings requires daemons to be explicitly reset first using
\code{daemons(0)}.}

\item{seed}{[default NULL] (optional) supply a random seed (single value,
interpreted as an integer). This is used to inititalise the L'Ecuyer-CMRG
RNG streams sent to each daemon. Note that reproducible results can be
expected only for \code{dispatcher = 'none'}, as the unpredictable timing
of task completions would otherwise influence the tasks sent to each
daemon. Even for \code{dispatcher = 'none'}, reproducibility is not
guaranteed if the order in which tasks are sent is not deterministic.}

\item{serial}{[default NULL] (optional, requires dispatcher) a configuration
created by \code{\link{serial_config}} to register serialization and
unserialization functions for normally non-exportable reference objects,
such as Arrow Tables or torch tensors.}

\item{tls}{[default NULL] (optional for secure TLS connections) if not
supplied, zero-configuration single-use keys and certificates are
automatically generated. If supplied, \strong{either} the character path to
a file containing the PEM-encoded TLS certificate and associated private
key (may contain additional certificates leading to a validation chain,
with the TLS certificate first), \strong{or} a length 2 character vector
comprising [i] the TLS certificate (optionally certificate chain) and [ii]
the associated private key.}

\item{pass}{[default NULL] (required only if the private key supplied to
\sQuote{tls} is encrypted with a password) For security, should be provided
through a function that returns this value, rather than directly.}

\item{.compute}{[default 'default'] character value for the compute profile
to use (each compute profile has its own independent set of daemons).}
}
\value{
The integer number of daemons launched locally (zero if specifying
  \sQuote{url} / using a remote launcher).
}
\description{
Set \sQuote{daemons} or persistent background processes to receive
\code{\link{mirai}} requests. Specify \sQuote{n} to create daemons on the
local machine. Specify \sQuote{url} to receive connections from remote
daemons (for distributed computing across the network). Specify
\sQuote{remote} to optionally launch remote daemons via a remote
configuration. By default, dispatcher ensures optimal scheduling.
}
\details{
Use \code{daemons(0)} to reset daemon connections:
\itemize{
  \item All connected daemons and/or dispatchers exit automatically.
  \item \pkg{mirai} reverts to the default behaviour of creating a new
  background process for each request.
  \item Any unresolved \sQuote{mirai} will return an \sQuote{errorValue} 19
  (Connection reset) after a reset.
  \item Calling \code{daemons} with revised (or even the same) settings for the
  same compute profile resets daemons before applying the new settings if
  \code{force = TRUE}.
}

If the host session ends, all connected dispatcher and daemon processes
automatically exit as soon as their connections are dropped (unless the
daemons were started with \code{autoexit = FALSE}). If a daemon is processing
a task, it will exit as soon as the task is complete.

To reset persistent daemons started with \code{autoexit = FALSE}, use
\code{daemons(NULL)} instead, which also sends exit signals to all connected
daemons prior to resetting.

For historical reasons, \code{daemons()} with no arguments returns the value
of \code{\link{status}}.
}
\section{Local Daemons}{


Daemons provide a potentially more efficient solution for asynchronous
operations as new processes no longer need to be created on an \emph{ad hoc}
basis.

Supply the argument \sQuote{n} to set the number of daemons. New background
\code{\link{daemon}} processes are automatically created on the local machine
connecting back to the host process, either directly or via dispatcher.
}

\section{Dispatcher}{


By default \code{dispatcher = TRUE} launches a background process running
\code{\link{dispatcher}}. Dispatcher connects to daemons on behalf of
the host and ensures optimal FIFO scheduling of tasks.

Specifying \code{dispatcher = FALSE}, uses the default behaviour without
additional dispatcher logic. In this case daemons connect directly to the
host and tasks are distributed in a round-robin fashion. Optimal scheduling
is not guaranteed as the duration of tasks cannot be known \emph{a priori},
hence tasks can be queued at one daemon while other daemons remain idle.
However, this provides the most resource-light approach, suited to working
with similar-length tasks, or where concurrent tasks typically do not exceed
available daemons.
}

\section{Distributed Computing}{


Specifying \sQuote{url} as a character string allows tasks to be distributed
across the network. \sQuote{n} is not required in this case, and disregarded
if supplied.

Supply a URL with a \sQuote{tcp://} scheme, such as
\sQuote{tcp://10.75.32.70:5555}. The host / dispatcher listens at this
address, utilising a single port. Individual daemons (started with
\code{\link{daemon}}) may then dial in to this URL. Host / dispatcher
automatically adjusts to the number of daemons actually connected, allowing
dynamic upscaling or downscaling as required.

Switching the URL scheme to \sQuote{tls+tcp://} automatically upgrades the
connection to use TLS. The auxiliary function \code{\link{host_url}} may be
used to construct a valid host URL based on the computer's hostname.

IPv6 addresses are also supported and must be enclosed in square brackets [ ]
to avoid confusion with the final colon separating the port. For example,
port 5555 on the IPv6 loopback address ::1 would be specified as
\sQuote{tcp://[::1]:5555}.

Specifying the wildcard value zero for the port number e.g.
\sQuote{tcp://[::1]:0} will automatically assign a free ephemeral port. Use
\code{\link{status}} to inspect the actual assigned port at any time.

Specify \sQuote{remote} with a call to \code{\link{remote_config}} or
\code{\link{ssh_config}} to launch daemons on remote machines. Otherwise,
\code{\link{launch_remote}} may be used to generate the shell commands to
deploy daemons manually on remote resources.
}

\section{Compute Profiles}{


By default, the \sQuote{default} compute profile is used. Providing a
character value for \sQuote{.compute} creates a new compute profile with the
name specified. Each compute profile retains its own daemons settings, and
may be operated independently of each other. Some usage examples follow:

\strong{local / remote} daemons may be set with a host URL and specifying
\sQuote{.compute} as \sQuote{remote}, which creates a new compute profile.
Subsequent \code{\link{mirai}} calls may then be sent for local computation
by not specifying the \sQuote{.compute} argument, or for remote computation
to connected daemons by specifying the \sQuote{.compute} argument as
\sQuote{remote}.

\strong{cpu / gpu} some tasks may require access to different types of
daemon, such as those with GPUs. In this case, \code{daemons()} may be called
to set up host URLs for CPU-only daemons and for those with GPUs, specifying
the \sQuote{.compute} argument as \sQuote{cpu} and \sQuote{gpu} respectively.
By supplying the \sQuote{.compute} argument to subsequent \code{\link{mirai}}
calls, tasks may be sent to either \sQuote{cpu} or \sQuote{gpu} daemons as
appropriate.

Note: further actions such as resetting daemons via \code{daemons(0)} should
be carried out with the desired \sQuote{.compute} argument specified.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# Create 2 local daemons (using dispatcher)
daemons(2)
status()
# Reset to zero
daemons(0)

# Create 2 local daemons (not using dispatcher)
daemons(2, dispatcher = FALSE)
status()
# Reset to zero
daemons(0)

# Set up dispatcher accepting TLS over TCP connections
daemons(url = host_url(tls = TRUE))
status()
# Reset to zero
daemons(0)

# Set host URL for remote daemons to dial into
daemons(url = host_url(), dispatcher = FALSE)
status()
# Reset to zero
daemons(0)

# Use with() to evaluate with daemons for the duration of the expression
with(
  daemons(2),
  {
    m1 <- mirai(Sys.getpid())
    m2 <- mirai(Sys.getpid())
    cat(m1[], m2[], "\n")
  }
)

}

\dontrun{
# Launch daemons on remotes 'nodeone' and 'nodetwo' using SSH
# connecting back directly to the host URL over a TLS connection:

daemons(n = 1L,
        url = host_url(tls = TRUE),
        remote = ssh_config(c('ssh://nodeone', 'ssh://nodetwo')),
        dispatcher = FALSE)

# Launch 4 daemons on the remote machine 10.75.32.90 using SSH tunnelling
# over port 5555 ('url' hostname must be '127.0.0.1'):

daemons(n = 4L,
        url = 'tcp://127.0.0.1:5555',
        remote = ssh_config('ssh://10.75.32.90', tunnel = TRUE, port = 5555))

}

}
