context('mirt')

test_that('dich', {
    data <- expand.table(LSAT7)        
    modm1 <- mirt(data, 1)
    modm2 <- mirt(data, 2)
    modm3 <- mirt(data, 1, itemtype = 'Rasch')
    modm4 <- mirt(data, 1, itemtype = '1PL')    
    sv <- mirt(data,1, startvalues = 'index')
    fp <- mirt(data,1, freepars = 'index')
    modm5 <- mirt(data,1, startvalues = sv, freepars = fp)
    expect_is(modm1, 'mirtClass')          
    expect_is(modm2, 'mirtClass')
    expect_is(modm3, 'mirtClass')
    expect_is(modm4, 'mirtClass')
    expect_is(modm5, 'mirtClass')
    
    fm1 <- fscores(modm1, verbose = FALSE)
    expect_is(fm1, 'matrix')
    fm2 <- fscores(modm2, method = 'MAP', verbose = FALSE)
    expect_is(fm2, 'matrix')
    fm3 <- fscores(modm3, method = 'ML', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
})

test_that('poly', {
    modp1 <- mirt(Science, 1)
    modp2 <- mirt(Science, 2)
    modp3 <- mirt(Science, 1, constrain = list(c(1,5)), parprior = list(c(2,'norm',0,1)))
    modp4 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'mcm'))
    expect_is(modp1, 'mirtClass')          
    expect_is(modp2, 'mirtClass')
    expect_is(modp3, 'mirtClass')
    expect_is(modp4, 'mirtClass')
    
    fm1 <- fscores(modp1, verbose = FALSE)
    expect_is(fm1, 'matrix')
    fm2 <- fscores(modp2, rotate = 'oblimin', verbose = FALSE)
    expect_is(fm2, 'matrix')
    fm3 <- fscores(modp3, rotate = 'oblimin', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modp4, verbose = FALSE)
    expect_is(fm4, 'matrix')
})

