% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.seqtest.R
\name{plot.seqtest}
\alias{plot.seqtest}
\title{Plot seqtest}
\usage{
\method{plot}{seqtest}(x, ...)
}
\arguments{
\item{x}{\code{seqtest} object}

\item{...}{further arguments passed to or from other methods}
}
\description{
This function plots the \code{seqtest} object
}
\examples{
#--------------------------------------
# Sequential triangular test for the product-moment correlation coefficient

seq.obj <- seqtest.cor(0.46, k = 14, rho = 0.3, delta = 0.2,
                       alpha = 0.05, beta = 0.2)

plot(seq.obj)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Schneider, B., Rasch, D., Kubinger, K. D., & Yanagida, T. (2015).
A Sequential triangular test of a correlation coefficient's null-hypothesis: 0 \eqn{< \rho \le \rho}0.
\emph{Statistical Papers, 56}, 689-699.
}
\seealso{
\code{\link{seqtest.cor}}, \code{\link{print.seqtest}}
}

