% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postSim.R
\name{postSim}
\alias{postSim}
\title{postSim: A function for simulating posterior odds}
\usage{
postSim(
  datasim,
  Prior = 0.01,
  PriorModel = c("prelim", "uniform")[1],
  eps = 0.05,
  erRs = 0.01,
  epc = Cmodel(),
  erRc = Cmodel(),
  MPc = 1,
  epa = 0.05,
  erRa = 0.01,
  MPa = 10,
  MPr = 2
)
}
\arguments{
\item{datasim}{Output from simLRgen function.}

\item{Prior}{Prior probability for H1}

\item{PriorModel}{Prior odds model: "prelim" is based on preliminary data, and "uniform" uses only the prior probability of H1}

\item{eps}{epsilon parameter sex}

\item{erRs}{error parameter sex}

\item{epc}{epsilon parameter hair color}

\item{erRc}{error parameter hair color}

\item{MPc}{Missing person hair color}

\item{epa}{epsilon parameter age}

\item{erRa}{error parameter age}

\item{MPa}{Missing person age}

\item{MPr}{Missing person age error range}
}
\value{
A value of posterior odds.
}
\description{
postSim: A function for simulating posterior odds
}
\examples{
library(forrel)
x = linearPed(2)
plot(x)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)
datasim = simLRgen(x, missing = 5, 10, 123)
postSim(datasim)
}
