% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm.R
\name{pmm}
\alias{pmm}
\title{Predictive Mean Matching}
\usage{
pmm(xtrain, xtest, ytrain, k = 1L, seed = NULL)
}
\arguments{
\item{xtrain}{Vector with predicted values in the training data.
Must be numeric, logical, or factor-valued.}

\item{xtest}{Vector as \code{xtrain} with predicted values in the test data.
Missing values are not allowed.}

\item{ytrain}{Vector of the observed values in the training data. Must be of same
length as \code{xtrain}.}

\item{k}{Number of nearest neighbours (donors) to sample from.}

\item{seed}{Integer random seed.}
}
\value{
Vector of the same length as \code{xtest} with values from \code{xtrain}.
}
\description{
For each value in the prediction vector \code{xtest}, one of the closest \code{k}
values in the prediction vector \code{xtrain} is randomly chosen and its observed
value in \code{ytrain} is returned. Note that \code{xtrain} and \code{xtest} must be both either
numeric, logical, or factor-valued. \code{ytest} can be of any type.
}
\examples{
pmm(xtrain = c(0.2, 0.3, 0.8), xtest = c(0.7, 0.2), ytrain = 1:3, k = 1)  # c(3, 1)
}
