% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlleleShare.R
\name{AlleleShare}
\alias{AlleleShare}
\title{Calculate numbers of sharing alleles each pair at each locus}
\usage{
AlleleShare(df,sep,replacement=FALSE)
}
\arguments{
\item{df}{a dataframe of genotype data with rownames of sample ID and column names of markers.}

\item{sep}{allele separator in the imported genotype data. Note: when using the special character like "|", remember to protect it as "\\|"(default).}

\item{replacement}{a logical variable. If it is TRUE, the pairs are sampled with replacement; if FALSE (default), the pairs are sampled without replacement.}
}
\value{
a dataframe of numbers of shared alleles. Each row denotes each pair; Each column denotes each locus.
}
\description{
Calculate numbers of sharing alleles each pair at each locus
}
\details{
This function calculates the numbers of shared alleles between each pair of individuals for a dataset.
}
\examples{
df <- data.frame(SNP1=c("A|A","T|T","A|T","A|T"),
                STR1=c("12|12","13|14","13|13","14|15"))
AlleleShare(df,"\\\\|",replacement=FALSE)

}
