\name{imgCor}
\encoding{latin1}
\alias{imgCor}


\title{Image Maps of Correlation Matrices between two Data Sets}

\description{
Display two-dimensional visualizations (image maps) of the correlation matrices within and between
two data sets.
}

\usage{
imgCor(X, Y, type = c("combine", "separate"), col = jet.colors, 
       X.names = TRUE, Y.names = TRUE,		 
       XsideColor = "blue", YsideColor = "red",
       symkey = TRUE, keysize = 1, interactive.dev = TRUE,		 
       cexRow = NULL, cexCol = NULL, 
       margins = c(5, 5), lhei = NULL, lwid = NULL) 
}

\arguments{
  \item{X}{numeric matrix or data frame \eqn{(n} x \eqn{p)}, the observations on the \eqn{X} variables.
    \code{NA}s are allowed.}
  \item{Y}{numeric matrix or data frame \eqn{(n} x \eqn{q)}, the observations on the \eqn{Y} variables.
    \code{NA}s are allowed.}
  \item{type}{character string, (partially) maching one of \code{"combine"} or \code{"separated"}, 
    determining the kind of plots to be produced. See Details.}	
  \item{col}{vector of colors such as that generated by 
    \code{\link{heat.colors}}, \code{\link{topo.colors}}, \code{\link{rainbow}} 
	or similar functions. Defaults to \code{jet.colors(26)}.}
  \item{X.names}{logical, should the name of each data on the axis \code{X} be shown ? 
    Possible character vector giving the names of the X-variables.}
  \item{Y.names}{logical, should the name of each data on the axis \code{Y} be shown ?
    Possible character vector giving the names of the Y-variables.}
  \item{XsideColor}{character string. The color name for a horizontal side bar that may 
    be used to annotate the columns of \code{X}.}
  \item{YsideColor}{character string. The color name for a vertical side bar that may be 
    used to annotate the rows of \code{Y}.}  
  \item{symkey}{boolean indicating whether the color key should be made symmetric about 0. 
	Defaults to \code{TRUE}.}
  \item{keysize}{positive numeric value indicating the size of the color key.}  
  \item{interactive.dev}{boolean. The current graphics device that will be opened is interactive?}
  \item{cexRow, cexCol}{positive numbers, used as \code{cex.axis} in for the row or column 
	axis labeling. The defaults currently only use number of rows or columns, respectively.}
  \item{margins}{numeric vector of length two containing the margins (see \code{\link{par}(mar)}) 
	for column and row names respectively.}
  \item{lhei, lwid}{arguments passed to \code{layout} to divide the device up into two 
    rows and two columns, with the row-heights \code{lhei} and the column-widths \code{lwid}.}	  
}

\details{
If \code{type="combine"}, the correlation matrix is computed of the combined
matrices \code{cbind(X, Y)} and then plotted. If \code{type="separate"}, 
three correlation matrices are computed, \code{cor(X)}, \code{cor(Y)} and 
\code{cor(X,Y)} and plotted separately on a device. In both cases, 
a color correlation scales strip is plotted.

The correlation matrices are pre-processed before calling the \code{image} 
function in order to get, as in the numerical representation, the diagonal 
from upper-left corner to bottom-right one.

Missing values are handled by casewise deletion in the \code{imgCor} function.

If \code{X.names = FALSE}, the name of each X-variable is hidden. 
Default value is \code{TRUE}.

If \code{Y.names = FALSE}, the name of each Y-variable is hidden. 
Default value is \code{TRUE}.
}

\author{Sbastien Djean, Ignacio Gonzlez and Pierre Monget.}

\seealso{\code{\link{cor}}, \code{\link{image}}, \code{\link{jet.colors}}.}

\examples{
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene

## 'combine' type plot (default)
imgCor(X, Y)

## 'separate' type plot
\dontrun{
imgCor(X, Y, type = "separate")

## 'separate' type plot without the name of datas
imgCor(X, Y, X.names = FALSE, Y.names = FALSE, type = "separate")
}
}

\keyword{multivariate}
\keyword{dplot}
