% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixgb_cv.R
\name{mixgb_cv}
\alias{mixgb_cv}
\title{Use cross-validation to find the optimal \code{nrounds}}
\usage{
mixgb_cv(
  data,
  nfold = 5,
  nrounds = 100,
  early_stopping_rounds = 10,
  response = NULL,
  select_features = NULL,
  stringsAsFactors = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data.frame or a data.table with missing values.}

\item{nfold}{The number of subsamples which are randomly partitioned and of equal size. Default: 5}

\item{nrounds}{The max number of iterations in XGBoost training. Default: 100}

\item{early_stopping_rounds}{An integer value \code{k}. Training will stop if the validation performance hasn't improved for \code{k} rounds.}

\item{response}{The name or column index of a response variable. Default: \code{NULL} (Randomly select an incomplete variable).}

\item{select_features}{The names or indices of selected features. Default: \code{NULL} (Select all other variables in the dataset).}

\item{stringsAsFactors}{A logical value indicating whether character vectors should be converted to factors.}

\item{verbose}{A logical value. Whether to print out cross-validation results during the process.}

\item{...}{Extra arguments to pass to XGBoost.}
}
\value{
A list of the optimal \code{nrounds}, \code{evaluation.log} and the chosen \code{response}.
}
\description{
Use cross-validation to find the optimal \code{nrounds} for an \code{Mixgb} imputer. Note that this method relies on the complete cases of a dataset to find the optimal \code{nrounds}.
}
\examples{
cv.results <- mixgb_cv(data = nhanes3)
cv.results$best.nrounds

imputed.data <- mixgb(data = nhanes3, m = 5, nrounds = cv.results$best.nrounds)
}
