% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_var.R
\name{show_var}
\alias{show_var}
\title{Show multiply imputed values for a single variable}
\usage{
show_var(imputation.list, var.name, original.data, true.values = NULL)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer.}

\item{var.name}{The name of a variable of interest.}

\item{original.data}{The original data with missing data.}

\item{true.values}{A vector of the true values (if known) of the missing values. In general, this is unknown.}
}
\value{
A data.table with \code{m} columns, each column represents the imputed values of all missing entries in the specified variable. If \code{true.values} is provided, the last column will be the true values of the missing values.
}
\description{
Show m sets of imputed values for a specified variable.
}
\examples{
#obtain m multiply datasets
library(mixgb)
mixgb.data <- mixgb(data = nhanes3, m = 3)

imputed.BMPHEAD <- show_var(imputation.list = mixgb.data, var.name = "BMPHEAD",
  original.data = nhanes3)
}
