% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node.R
\name{is_context}
\alias{is_context}
\title{Report the nature of a node in a context tree}
\usage{
is_context(node)
}
\arguments{
\item{node}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}
}
\value{
\code{TRUE} if the node \code{node} is a proper context,
\code{FALSE} when this is not the case
}
\description{
This function returns \code{TRUE} if the node is a proper context, \code{FALSE}
in the other case.
}
\examples{
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 3)
draw(dts_ctree)
## 0, 0 is a context but 1, 0 is not
is_context(find_sequence(dts_ctree, c(0, 0)))
is_context(find_sequence(dts_ctree, c(1, 0)))
}
