% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nlme.mmkin.R
\name{plot.nlme.mmkin}
\alias{plot.nlme.mmkin}
\title{Plot a fitted nonlinear mixed model obtained via an mmkin row object}
\usage{
\method{plot}{nlme.mmkin}(
  x,
  i = 1:ncol(x$mmkin_orig),
  main = "auto",
  legends = 1,
  resplot = c("time", "errmod"),
  standardized = FALSE,
  show_errmin = TRUE,
  errmin_var = "All data",
  errmin_digits = 3,
  cex = 0.7,
  rel.height.middle = 0.9,
  ymax = "auto",
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{nlme.mmkin}}}

\item{i}{A numeric index to select datasets for which to plot the nlme fit,
in case plots get too large}

\item{main}{The main title placed on the outer margin of the plot.}

\item{legends}{An index for the fits for which legends should be shown.}

\item{resplot}{Should the residuals plotted against time, using
\code{\link{mkinresplot}}, or as squared residuals against predicted
values, with the error model, using \code{\link{mkinerrplot}}.}

\item{standardized}{Should the residuals be standardized? This option
is passed to \code{\link{mkinresplot}}, it only takes effect if
\code{resplot = "time"}.}

\item{show_errmin}{Should the chi2 error level be shown on top of the plots
to the left?}

\item{errmin_var}{The variable for which the FOCUS chi2 error value should
be shown.}

\item{errmin_digits}{The number of significant digits for rounding the FOCUS
chi2 error percentage.}

\item{cex}{Passed to the plot functions and \code{\link{mtext}}.}

\item{rel.height.middle}{The relative height of the middle plot, if more
than two rows of plots are shown.}

\item{ymax}{Maximum y axis value for \code{\link{plot.mkinfit}}.}

\item{\dots}{Further arguments passed to \code{\link{plot.mkinfit}} and
\code{\link{mkinresplot}}.}
}
\value{
The function is called for its side effect.
}
\description{
Plot a fitted nonlinear mixed model obtained via an mmkin row object
}
\examples{
ds <- lapply(experimental_data_for_UBA_2019[6:10],
 function(x) subset(x$data[c("name", "time", "value")], name == "parent"))
f <- mmkin("SFO", ds, quiet = TRUE, cores = 1)
#plot(f) # too many panels for pkgdown
plot(f[, 3:4])
library(nlme)
f_nlme <- nlme(f)

#plot(f_nlme) # too many panels for pkgdown
plot(f_nlme, 3:4)
}
\author{
Johannes Ranke
}
