% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions_stra.R
\name{stratified.kfolds}
\alias{stratified.kfolds}
\title{Partition an mldr object into k folds}
\usage{
stratified.kfolds(mld, k = 5, seed = 10, get.indices = FALSE)
}
\arguments{
\item{mld}{The \code{mldr} object to be partitioned}

\item{k}{The number of folds to be generated. By default is 5}

\item{seed}{The seed to initialize the random number generator. By default is 10. Change it if you want to obtain partitions containing
different samples, for instance to use a 2x5 fcv strategy}

\item{get.indices}{A logical value indicating whether to return lists of indices or lists of \code{"mldr"} objects}
}
\value{
An \code{mldr.folds} object. This is a list containing k elements, one for each fold. Each element is made up
of two mldr objects, called \code{train} and \code{test}
}
\description{
This method partitions the given dataset into k folds using a stratified strategy, providing training and test partitions for each fold.

Implementation of the algorithm defined in:
  Charte, F., Rivera, A., del Jesus, M. J., & Herrera, F. (2016, April). On the
  impact of dataset complexity and sampling strategy in multilabel classifiers
  performance. In International Conference on Hybrid Artificial Intelligence
  Systems (pp. 500-511). Springer, Cham.
}
\examples{
\dontrun{
library(mldr.datasets)
library(mldr)
folds.emotions <- stratified.kfolds(emotions)
summary(folds.emotions[[1]]$train)
summary(folds.emotions[[1]]$test)
}
}
