% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_field_json.R
\name{write_field_json}
\alias{write_field_json}
\title{Write Field Data in JSON format}
\usage{
write_field_json(x, path, overwrite = FALSE)
}
\arguments{
\item{x}{'list' with compoents of class 'mlms.sheet'.
See returned object from the \code{\link{read_field_xlsx}} function.}

\item{path}{'character' string.
Path to the JSON file.}

\item{overwrite}{'logical' flag.
Whether to overwrite the JSON file.}
}
\value{
Worksheet data as a 'list' with compoents of class 'mlms.sheet'.
}
\description{
Write field visit monitoring event data to JSON format.
}
\examples{
sheets <- read_field_xlsx(
  path = system.file("/extdata/ex-field.xlsx", package = "mlms")
)

path <- tempfile("sheets-", fileext = ".json")
write_field_json(sheets, path = path)
if (interactive()) file.show(path)

unlink(path)
}
\seealso{
\code{\link{read_field_json}} function for reading field data in JSON format.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
