% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeaturesWrapper.R
\name{makeExtractFDAFeatsWrapper}
\alias{makeExtractFDAFeatsWrapper}
\title{Fuse learner with an extractFDAFeatures method.}
\usage{
makeExtractFDAFeatsWrapper(learner, feat.methods = list())
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{feat.methods}{(named \link{list})\cr
List of functional features along with the desired methods for each functional feature.
\dQuote{all} applies the \link{extractFDAFeatures} method to each
functional feature.
Names of \code{feat.methods} must match column names of functional features.
Available feature extraction methods are available under family \code{fda_featextractor}.
Default is \link{list} which does nothing.}
}
\value{
\link{Learner}.
}
\description{
Fuses a base learner with an extractFDAFeatures method. Creates a learner object, which can be
used like any other learner object.
Internally uses \link{extractFDAFeatures} before training the learner and
\link{reextractFDAFeatures} before predicting.
}
\seealso{
Other fda: \code{\link{extractFDAFeatures}},
  \code{\link{makeExtractFDAFeatMethod}}

Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
