% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_phoneme.R
\name{mlr_tasks_phoneme}
\alias{mlr_tasks_phoneme}
\title{Phoneme Classification Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link[mlr3:TaskClassif]{mlr3::TaskClassif}.
}
\description{
The task contains a single functional covariate and 5 equally big classes (aa, ao, dcl, iy, sh).
The aim is to predict the class of the phoneme in the functional, which is a
log-periodogram.\cr
This is a subset of the full dataset, which is contained in the package \code{fda.usc}.
}
\section{Dictionary}{

This \link[mlr3:Task]{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_tasks]{mlr_tasks}
or with the associated sugar function \link[mlr3:mlr_sugar]{tsk()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("phoneme")
tsk("phoneme")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Dimensions: 250x2
\item Properties: \dQuote{multiclass}
\item Has Missings: \code{FALSE}
\item Target: \dQuote{class}
\item Features: \dQuote{X}
}
}

\references{
Ferraty, Frédric, Vieu, Philippe (2003).
\dQuote{Curves discrimination: a nonparametric functional approach.}
\emph{Computational Statistics & Data Analysis}, \bold{44}(1-2), 161--173.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Task]{Tasks}: \link[mlr3:mlr_tasks]{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[mlr3:Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{mlr_tasks_dti}},
\code{\link{mlr_tasks_fuel}}
}
\concept{Task}
