% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorRandomSearch.R
\name{mlr_fselectors_random_search}
\alias{mlr_fselectors_random_search}
\alias{FSelectorRandomSearch}
\title{Feature Selection with Random Search}
\source{
Bergstra J, Bengio Y (2012).
\dQuote{Random Search for Hyper-Parameter Optimization.}
\emph{Journal of Machine Learning Research}, \bold{13}(10), 281--305.
\url{https://jmlr.csail.mit.edu/papers/v13/bergstra12a.html}.
}
\description{
Feature selection using Random Search Algorithm.
}
\details{
The feature sets are randomly drawn.
The sets are evaluated in batches of size \code{batch_size}.
Larger batches mean we can parallelize more, smaller batches imply a more fine-grained checking of termination criteria.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("random_search")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

\describe{
\item{\code{max_features}}{\code{integer(1)}\cr
Maximum number of features.
By default, number of features in \link[mlr3:Task]{mlr3::Task}.}
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of feature sets to try in a batch.}
}
}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  fselector = fs("random_search"),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 10
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}},
\code{\link{mlr_fselectors}}
}
\concept{FSelector}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorRandomSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorRandomSearch-new}{\code{FSelectorRandomSearch$new()}}
\item \href{#method-FSelectorRandomSearch-clone}{\code{FSelectorRandomSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRandomSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRandomSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRandomSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRandomSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRandomSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRandomSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
