% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3fselect.svm_rfe}
\alias{mlr3fselect.svm_rfe}
\title{SVM-RFE Callback}
\source{
Guyon I, Weston J, Barnhill S, Vapnik V (2002).
\dQuote{Gene Selection for Cancer Classification using Support Vector Machines.}
\emph{Machine Learning}, \bold{46}(1), 389--422.
ISSN 1573-0565, \doi{10.1023/A:1012487302797}.
}
\description{
Runs a recursive feature elimination with a \link[mlr3learners:mlr_learners_classif.svm]{mlr3learners::LearnerClassifSVM}.
The SVM must be configured with \code{type = "C-classification"} and \code{kernel = "linear"}.
}
\examples{
clbk("mlr3fselect.svm_rfe")

library(mlr3learners)

# Create instance with classification svm with linear kernel
instance = fsi(
  task = tsk("sonar"),
  learner = lrn("classif.svm", type = "C-classification", kernel = "linear"),
  resampling = rsmp("cv", folds = 3),
  measures = msr("classif.ce"),
  terminator = trm("none"),
  callbacks = clbk("mlr3fselect.svm_rfe"),
  store_models = TRUE
)

fselector = fs("rfe", feature_number = 5, n_features = 10)

# Run recursive feature elimination on the Sonar data set
fselector$optimize(instance)
}
