% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqOptimizer.R
\name{AcqOptimizer}
\alias{AcqOptimizer}
\title{Acquisition Function Optimizer}
\description{
Optimizer for \link{AcqFunction}s which performs the acquisition function optimization.
Wraps an \link[bbotk:Optimizer]{bbotk::Optimizer} and \link[bbotk:Terminator]{bbotk::Terminator}.
}
\section{Parameters}{

\describe{
\item{\code{n_candidates}}{\code{integer(1)}\cr
Number of candidate points to propose.
Note that this does not affect how the acquisition function itself is calculated (e.g., setting \code{n_candidates > 1} will not
result in computing the q- or multi-Expected Improvement) but rather the top \code{n-candidates} are selected from the
\link[bbotk:Archive]{bbotk::Archive} of the acquisition function \link[bbotk:OptimInstance]{bbotk::OptimInstance}.
Note that setting \code{n_candidates > 1} is usually not a sensible idea but it is still supported for experimental reasons.
Default is \code{1}.}
\item{\code{logging_level}}{\code{character(1)}\cr
Logging level during the acquisition function optimization.
Can be \code{"fatal"}, \code{"error"}, \code{"warn"}, \code{"info"}, \code{"debug"} or \code{"trace"}.
Default is \code{"warn"}, i.e., only warnings are logged.
}
\item{\code{warmstart}}{\code{logical(1)}\cr
Should the acquisition function optimization be warm-started by evaluating the best point(s) present in the \link[bbotk:Archive]{bbotk::Archive} of
the actual \link[bbotk:OptimInstance]{bbotk::OptimInstance}?
This is sensible when using a population based acquisition function optimizer, e.g., local search or mutation.
Default is \code{FALSE}.
}
\item{\code{warmstart_size}}{\code{integer(1) | "all"}\cr
Number of best points selected from the \link[bbotk:Archive]{bbotk::Archive} that are to be used for warm starting.
Can also be "all" to use all available points.
Only relevant if \code{warmstart = TRUE}.
Default is \code{1}.
}
\item{\code{skip_already_evaluated}}{\code{logical(1)}\cr
It can happen that the candidate resulting of the acquisition function optimization was already evaluated in a previous
iteration. Should this candidate proposal be ignored and the next best point be selected as a candidate?
Default is \code{TRUE}.
}
\item{\code{catch_errors}}{\code{logical(1)}\cr
Should errors during the acquisition function optimization be caught and propagated to the \code{loop_function} which can then handle
the failed acquisition function optimization appropriately by, e.g., proposing a randomly sampled point for evaluation?
Default is \code{TRUE}.
}
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(learner, archive = instance$archive)

  acq_function = acqf("ei", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$update()

  acq_optimizer = acqo(
    optimizer = opt("random_search", batch_size = 1000),
    terminator = trm("evals", n_evals = 1000),
    acq_function = acq_function)

  acq_optimizer$optimize()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{optimizer}}{(\link[bbotk:Optimizer]{bbotk::Optimizer}).}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator}).}

\item{\code{acq_function}}{(\link{AcqFunction}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{print_id}}{(\code{character})\cr
Id used when printing.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqOptimizer-new}{\code{AcqOptimizer$new()}}
\item \href{#method-AcqOptimizer-format}{\code{AcqOptimizer$format()}}
\item \href{#method-AcqOptimizer-print}{\code{AcqOptimizer$print()}}
\item \href{#method-AcqOptimizer-optimize}{\code{AcqOptimizer$optimize()}}
\item \href{#method-AcqOptimizer-clone}{\code{AcqOptimizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizer$new(optimizer, terminator, acq_function = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optimizer}}{(\link[bbotk:Optimizer]{bbotk::Optimizer}).}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator}).}

\item{\code{acq_function}}{(\code{NULL} | \link{AcqFunction}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizer-format"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizer-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizer$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizer-print"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizer-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizer-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizer-optimize}{}}}
\subsection{Method \code{optimize()}}{
Optimize the acquisition function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizer$optimize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with 1 row per optimum and x as columns.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
