% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cite_bib.R
\name{cite_bib}
\alias{cite_bib}
\title{Cite using a Bibtex File}
\usage{
cite_bib(package, key)
}
\arguments{
\item{package}{(\code{character(1)})\cr
Package to read the bibtex file from.}

\item{key}{(\code{character(1)})\cr
Entry of the bibtex file.}
}
\value{
(\code{character(1)}) Bibentry formated as Rd.
}
\description{
This function is called by the provided Rd macro \code{\\cite{pkg}{key}}:
\itemize{
\item Parses the bibtex file \code{references.bib} in the root directory of package \code{package} using \code{\link[bibtex:read.bib]{bibtex::read.bib()}}.
\item Extracts the entry with key \code{key}.
\item Converts to Rd with \code{\link[tools:toRd]{tools::toRd()}}.
}
}
\examples{
# examplary bibtex file
path = system.file("references.bib", package = "mlr3misc")
cat(readLines(path), sep = "\\n")

# return value: raw rd
cite_bib("mlr3misc", "mlr")
}
