% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskSurvRegr.R
\name{mlr_pipeops_trafotask_survregr}
\alias{mlr_pipeops_trafotask_survregr}
\alias{PipeOpTaskSurvRegr}
\title{PipeOpTaskSurvRegr}
\description{
Transform \link{TaskSurv} to \link[mlr3:TaskRegr]{TaskRegr}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpTaskTransformer}.

The output is the input \link{TaskSurv} transformed to a \link[mlr3:TaskRegr]{TaskRegr}.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements
\itemize{
\item \code{instatus}: Censoring status from input training task.
\item \code{outstatus} : Censoring status from input prediction task.
}
}

\section{Parameters}{

The parameters are
\itemize{
\item \verb{method::character(1))}\cr
Method to use for dealing with censoring. Options are \code{"ipcw"} (Vock et al., 2016): censoring
is column is removed and a \code{weights} column is added, weights are inverse estimated survival
probability of the censoring distribution evaluated at survival time;
\code{"mrl"} (Klein and Moeschberger, 2003): survival time of censored
observations is transformed to the observed time plus the mean residual life-time at the moment
of censoring; \code{"bj"} (Buckley and James, 1979): Buckley-James imputation assuming an AFT
model form, calls \link[bujar:bujar]{bujar::bujar}; \code{"delete"}: censored observations are deleted from the
data-set - should be used with caution if censoring is informative; \code{"omit"}: the censoring
status column is deleted - again should be used with caution; \code{"reorder"}: selects features and
targets and sets the target in the new task object. Note that \code{"mrl"} and \code{"ipcw"} will perform
worse with Type I censoring.
\item \verb{estimator::(character(1))}\cr
Method for calculating censoring weights or mean residual lifetime in \code{"mrl"},
current options are: \code{"kaplan"}: unconditional Kaplan-Meier estimator;
\code{"akritas"}: conditional non-parameteric nearest-neighbours estimator;
\code{"cox"}.
\item \verb{alpha::(numeric(1))}\cr
When \code{ipcw} is used, optional hyper-parameter that adds an extra penalty to the weighting for
censored observations. If set to \code{0} then censored observations are given zero weight and
deleted, weighting only the non-censored observations. A weight for an observation is then
\eqn{(\delta + \alpha(1-\delta))/G(t)} where \eqn{\delta} is the censoring indicator.
\item \code{eps::numeric(1)}\cr
Small value to replace \code{0} survival probabilities with in IPCW to prevent infinite weights.
\item \verb{lambda::(numeric(1))}\cr
Nearest neighbours parameter for the \code{"akritas"} estimator in the \href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners package}, default \code{0.5}.
\item \verb{features, target :: character())}\cr
For \code{"reorder"} method, specify which columns become features and targets.
\item \verb{learner cneter, mimpu, iter.bj, max.cycle, mstop, nu}\cr
Passed to \link[bujar:bujar]{bujar::bujar}.
}
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)

  # these methods are generally only successful if censoring is not too high
  # create survival task by undersampling
  task = tsk("rats")$filter(
    c(which(tsk("rats")$truth()[, 2] == 1),
      sample(which(tsk("rats")$truth()[, 2] == 0), 42))
  )

  # deletion
  po = po("trafotask_survregr", method = "delete")
  po$train(list(task, NULL))[[1]] # 42 deleted

  # omission
  po = po("trafotask_survregr", method = "omit")
  po$train(list(task, NULL))[[1]]

  if (requireNamespace("mlr3extralearners", quietly = TRUE)) {
    # ipcw with Akritas
    po = po("trafotask_survregr", method = "ipcw", estimator = "akritas", lambda = 0.4, alpha = 0)
    new_task = po$train(list(task, NULL))[[1]]
    print(new_task)
    new_task$weights
  }

  # mrl with Kaplan-Meier
  po = po("trafotask_survregr", method = "mrl")
  new_task = po$train(list(task, NULL))[[1]]
  data.frame(new = new_task$truth(), old = task$truth())

  # Buckley-James imputation
  if (requireNamespace("bujar", quietly = TRUE)) {
    po = po("trafotask_survregr", method = "bj")
    new_task = po$train(list(task, NULL))[[1]]
    data.frame(new = new_task$truth(), old = task$truth())
  }

  # reorder - in practice this will be only be used in a few graphs
  po = po("trafotask_survregr", method = "reorder", features = c("sex", "rx", "time", "status"),
    target = "litter")
  new_task = po$train(list(task, NULL))[[1]]
  print(new_task)

  # reorder using another task for feature names
  po = po("trafotask_survregr", method = "reorder", target = "litter")
  new_task = po$train(list(task, task))[[1]]
  print(new_task)
}
}
}
\references{
Buckley, Jonathan, James, Ian (1979).
\dQuote{Linear Regression with Censored Data.}
\emph{Biometrika}, \bold{66}(3), 429--436.
\doi{10.2307/2335161}, \url{https://www.jstor.org/stable/2335161}.

Klein, P J, Moeschberger, L M (2003).
\emph{Survival analysis: techniques for censored and truncated data}, 2 edition.
Springer Science & Business Media.
ISBN 0387216456.

Vock, M D, Wolfson, Julian, Bandyopadhyay, Sunayan, Adomavicius, Gediminas, Johnson, E P, Vazquez-Benitez, Gabriela, O'Connor, J P (2016).
\dQuote{Adapting machine learning techniques to censored time-to-event health record data: A general-purpose approach using inverse probability of censoring weighting.}
\emph{Journal of Biomedical Informatics}, \bold{61}, 119--131.
\doi{https://doi.org/10.1016/j.jbi.2016.03.009}, \url{https://www.sciencedirect.com/science/article/pii/S1532046416000496}.
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}},
\code{\link{PipeOpTransformer}},
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_regrsurv}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_regrsurv}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_regrsurv}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3proba:PipeOpTransformer]{mlr3proba::PipeOpTransformer}} -> \code{\link[mlr3proba:PipeOpTaskTransformer]{mlr3proba::PipeOpTaskTransformer}} -> \code{PipeOpTaskSurvRegr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpTaskSurvRegr$new()}}
\item \href{#method-clone}{\code{PipeOpTaskSurvRegr$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvRegr$new(id = "trafotask_survregr", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTaskSurvRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
