% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_regr_cookfarm_profiles.R
\docType{data}
\name{mlr_tasks_cookfarm}
\alias{mlr_tasks_cookfarm}
\alias{cookfarm}
\title{Cookfarm Profiles Regression Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskRegr}.
}
\usage{
data(cookfarm)
}
\description{
The R.J. Cook Agronomy Farm (cookfarm) is a Long-Term Agroecosystem Research
Site operated by Washington State University, located near Pullman,
Washington, USA. Contains spatio-temporal (3D+T) measurements of three soil
properties and a number of spatial and temporal regression covariates.

Here, only the "Profiles" dataset is used from the collection.
The \code{Date} column was appended from the \code{readings} dataset.
500 random samples were drawn from the complete sample.

See \link[GSIF:cookfarm]{GSIF::cookfarm} for more detailed information.
}
\section{Usage}{
\preformatted{mlr_tasks$get("cookfarm")
tsk("cookfarm")
}
}

\references{
Gasch, C.K., Hengl, T., Gräler, B., Meyer, H., Magney, T., Brown, D.J., 2015.
Spatio-temporal interpolation of soil water, temperature, and electrical
conductivity in 3D+T: the Cook Agronomy Farm data set. Spatial Statistics,
14, pp.70–90.

Gasch, C.K., D.J. Brown, E.S. Brooks, M. Yourek, M. Poggio, D.R. Cobos, C.S.
Campbell, 2016? Retroactive calibration of soil moisture sensors using a
two-step, soil-specific correction. Submitted to Vadose Zone Journal.

Gasch, C.K., D.J. Brown, C.S. Campbell, D.R. Cobos, E.S. Brooks, M. Chahal,
M. Poggio, 2016? A field-scale sensor network data set for monitoring and
modeling the spatial and temporal variation of soil moisture in a dryland
agricultural field. Submitted to Water Resources Research.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}

\code{as.data.table(mlr_tasks)} for a complete table of all (also dynamically created) \link[=Task]{Tasks}.

Other Task: 
\code{\link{TaskClassifST}},
\code{\link{TaskRegrST}},
\code{\link{mlr_tasks_diplodia}},
\code{\link{mlr_tasks_ecuador}}

Other Task: 
\code{\link{TaskClassifST}},
\code{\link{TaskRegrST}},
\code{\link{mlr_tasks_diplodia}},
\code{\link{mlr_tasks_ecuador}}
}
\concept{Task}
\keyword{datasets}
