% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerIrace.R
\name{mlr_tuners_irace}
\alias{mlr_tuners_irace}
\alias{TunerIrace}
\title{Tuning via Iterated Racing.}
\source{
Lopez-Ibanez M, Dubois-Lacoste J, Caceres LP, Birattari M, Stuetzle T (2016).
\dQuote{The irace package: Iterated racing for automatic algorithm configuration.}
\emph{Operations Research Perspectives}, \bold{3}, 43--58.
\doi{https://doi.org/10.1016/j.orp.2016.09.002}.
}
\description{
\code{TunerIrace} class that implements iterated racing. Calls \code{\link[irace:irace]{irace::irace()}}
from package \CRANpkg{irace}.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_tuners} or with the associated sugar function \code{\link[=tnr]{tnr()}}:\preformatted{TunerIrace$new()
mlr_tuners$get("irace")
tnr("irace")
}
}

\section{Parameters}{

\describe{
\item{\code{n_instances}}{\code{integer(1)}\cr
Number of resampling instances.}
}

For the meaning of all other parameters, see \code{\link[irace:defaultScenario]{irace::defaultScenario()}}. Note
that we have removed all control parameters which refer to the termination of
the algorithm. Use \link{TerminatorEvals} instead. Other terminators do not work
with \code{TunerIrace}.
}

\section{Archive}{

The \link{ArchiveTuning} holds the following additional columns:
\itemize{
\item \code{"race"} (\code{integer(1)})\cr
Race iteration.
\item \code{"step"} (\code{integer(1)})\cr
Step number of race.
\item \code{"instance"} (\code{integer(1)})\cr
Identifies resampling instances across races and steps.
\item \code{"configuration"} (\code{integer(1)})\cr
Identifies configurations across races and steps.
}
}

\section{Result}{

The tuning result (\code{instance$result}) is the best performing elite of
the final race. The reported performance is the average performance estimated
on all used instances.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\section{Logging}{


All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\examples{
# retrieve task
task = tsk("pima")

# load learner and set search space
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

# hyperparameter tuning on the pima indians diabetes data set
instance = tune(
  method = "irace",
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 42
)

# best performing hyperparameter configuration
instance$result

# all evaluated hyperparameter configuration
as.data.table(instance$archive)

# fit final model on complete data set
learner$param_set$values = instance$result_learner_param_vals
learner$train(task)
}
\seealso{
Other Tuner: 
\code{\link{mlr_tuners_cmaes}},
\code{\link{mlr_tuners_design_points}},
\code{\link{mlr_tuners_gensa}},
\code{\link{mlr_tuners_grid_search}},
\code{\link{mlr_tuners_nloptr}},
\code{\link{mlr_tuners_random_search}}
}
\concept{Tuner}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerFromOptimizer]{mlr3tuning::TunerFromOptimizer}} -> \code{TunerIrace}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TunerIrace$new()}}
\item \href{#method-optimize}{\code{TunerIrace$optimize()}}
\item \href{#method-clone}{\code{TunerIrace$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format">}\href{../../mlr3tuning/html/Tuner.html#method-format}{\code{mlr3tuning::Tuner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print">}\href{../../mlr3tuning/html/Tuner.html#method-print}{\code{mlr3tuning::Tuner$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerIrace$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceSingleCrit} until termination.
The single evaluations and the final results will be written into the
\link{ArchiveTuning} that resides in the \link{TuningInstanceSingleCrit}. The final
result is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerIrace$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceSingleCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerIrace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
