% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_spaces_rbv1.R
\name{mlr_tuning_spaces_rbv1}
\alias{mlr_tuning_spaces_rbv1}
\alias{mlr_tuning_spaces_classif.glmnet.rbv1}
\alias{mlr_tuning_spaces_classif.kknn.rbv1}
\alias{mlr_tuning_spaces_classif.ranger.rbv1}
\alias{mlr_tuning_spaces_classif.rpart.rbv1}
\alias{mlr_tuning_spaces_classif.svm.rbv1}
\alias{mlr_tuning_spaces_classif.xgboost.rbv1}
\alias{mlr_tuning_spaces_regr.glmnet.rbv1}
\alias{mlr_tuning_spaces_regr.kknn.rbv1}
\alias{mlr_tuning_spaces_regr.ranger.rbv1}
\alias{mlr_tuning_spaces_regr.rpart.rbv1}
\alias{mlr_tuning_spaces_regr.svm.rbv1}
\alias{mlr_tuning_spaces_regr.xgboost.rbv1}
\title{RandomBot Tuning Spaces}
\source{
Kuehn D, Probst P, Thomas J, Bischl B (2018).
\dQuote{Automatic Exploration of Machine Learning Experiments on OpenML.}
1806.10961, \url{https://arxiv.org/abs/1806.10961}.
}
\description{
Tuning spaces from the Kuehn (2018) article.
}
\section{glmnet tuning space}{

\itemize{
\item alpha \eqn{[0, 1]}{[0, 1]}
\item s \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
}
}

\section{kknn tuning space}{

\itemize{
\item k \eqn{[1, 30]}{[1, 30]}
}
}

\section{ranger tuning space}{

\itemize{
\item num.trees \eqn{[1, 2000]}{[1, 2000]}
\item replace [TRUE,FALSE]
\item sample.fraction \eqn{[0.1, 1]}{[0.1, 1]}
\item mtry.ratio \eqn{[0, 1]}{[0, 1]}
\item respect.unordered.factors [\dQuote{ignore}, \dQuote{order}]
\item min.node.size \eqn{[1, 100]}{[1, 100]}
}

The tuning space of the ranger learner is slightly different from the original paper.
The hyperparameter \code{mtry.power} is replaced by \code{mtry.ratio} and \code{min.node.size} is explored in a range from 1 to 100.
}

\section{rpart tuning space}{

\itemize{
\item cp \eqn{[0, 1]}{[0, 1]}
\item maxdepth \eqn{[1, 30]}{[1, 30]}
\item minbucket \eqn{[1, 60]}{[1, 60]}
\item minsplit \eqn{[1, 60]}{[1, 60]}
}
}

\section{svm tuning space}{

\itemize{
\item kernel [\dQuote{linear}, \dQuote{polynomial}, \dQuote{radial}]
\item cost \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item gamma \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item degree \eqn{[2, 5]}{[2, 5]}
}
}

\section{xgboost tuning space}{

\itemize{
\item nrounds \eqn{[1, 5000]}{[1, 5000]}
\item eta \eqn{[1e-04, 1]}{[1e-04, 1]} Logscale
\item subsample \eqn{[0, 1]}{[0, 1]}
\item booster [\dQuote{gblinear}, \dQuote{gbtree}, \dQuote{dart}]
\item max_depth \eqn{[1, 15]}{[1, 15]}
\item min_child_weight \eqn{[1, 100]}{[1, 100]} Logscale
\item colsample_bytree \eqn{[0, 1]}{[0, 1]}
\item colsample_bylevel \eqn{[0, 1]}{[0, 1]}
\item lambda \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item alpha \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
}
}

