% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{applyCPO}
\alias{applyCPO}
\title{Apply a CPO to Data}
\usage{
applyCPO(cpo, task)
}
\arguments{
\item{cpo}{[\code{\link{CPO}} | \code{\link{CPORetrafo}}]\cr
The CPO or CPORetrafo representing the operation to perform.}

\item{task}{[\code{\link[mlr]{Task}} | \code{\link[base]{data.frame}}]\cr
The data to operate on.}
}
\value{
[\code{\link[mlr]{Task}} | \code{\link[base]{data.frame}}]. The transformed data, augmented with a \code{\link{inverter}}
and possibly a \code{\link{retrafo}} tag.
}
\description{
The given transformation will be applied to the data in the given \code{\link[mlr]{Task}} or \code{\link[base]{data.frame}}.

If the input data is a \code{data.frame}, the returned object will in most cases also be a \code{data.frame}, with exceptions
if the applied \code{\link{CPO}} performs a conversion to a \code{\link[mlr]{Task}}. If the input data is a Task, its type
will only be changed to a different type of Task if the applied CPO performs such a conversion.

The \code{\link{\%>>\%}} operator can be used synonymously to apply CPO objects to data. In case of \code{\link{CPORetrafo}},
\code{\link[stats]{predict}} can be used synonymously.
}
\section{Application of \code{CPO}}{

Application of a \code{\link{CPO}} is supposed to perform \emph{preprocessing} on a given data set, to prepare it e.g. for model
fitting with a \code{\link[mlr:makeLearner]{Learner}}, or for other data handling tasks. When this preprocessing is performed, care is taken
to make the transformation repeatable on later prediction or validation data. For this,
the returned data set will have a \code{\link{CPORetrafo}} and
\code{\link{CPOInverter}} object attached to it, which can be retrieved using \code{\link{retrafo}} and \code{\link{inverter}}.
These can be used to perform the same transformation on new data, or to invert a prediction made with the transformed data.

An applied \code{\link{CPO}} can change the content of feature columns, target columns of Tasks,
and may even change the number of rows of a given data set.
}

\section{Application of \code{CPORetrafo}}{

Application of a \code{\link{CPORetrafo}} is supposed to perform a transformation that mirrors the transformation done before
on a training data set. It should be used when trying to make predictions from new data, using a model that was trained with
data preprocessed using a \code{\link{CPO}}. The predictions made may then need to be inverted. For this,
the returned data set will have a \code{\link{CPOInverter}} object attached to it,
which can be retrieved using \code{\link{inverter}}.

An applied \code{\link{CPORetrafo}} may change the content of feature columns and target columns of Tasks, but will never
change the number or order of rows of a given data set.
}

\seealso{
Other operators: \code{\link{CPO}}, \code{\link{\%>>\%}},
  \code{\link{as.list.CPO}}, \code{\link{attachCPO}},
  \code{\link{composeCPO}}, \code{\link{pipeCPO}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{as.list.CPO}}, \code{\link{clearRI}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{as.list.CPO}}, \code{\link{clearRI}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}
}
