% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross2_to_grcm39.R
\name{cross2_to_grcm39}
\alias{cross2_to_grcm39}
\title{Convert a cross2 object to use mouse build GRCm39}
\usage{
cross2_to_grcm39(cross, array = c("guess", "gm", "mm", "mini", "muga"))
}
\arguments{
\item{cross}{Object of class \code{"cross2"}, as produced by
\code{\link[qtl2:read_cross2]{qtl2::read_cross2()}}. Must have markers from just one of the MUGA arrays.}

\item{array}{Character string indicating which of the MUGA arrays
was used ("gm" for GigaMUGA, "mm" for MegaMUGA, "mini" for
MiniMUGA, or "muga" for the original MUGA), or "guess" (the
default) to pick the array with the most matching marker names.}
}
\value{
The input \code{cross} object with markers subset to those in build GRCm39
and with \code{pmap} and \code{gmap} replaced with the GRCm39 physical map and
revised Cox genetic map, respectively.
}
\description{
Convert a cross2 object (with genotypes from one of the MUGA
arrays) to use mouse build GRCm39 and the revised Cox map
positions, revising marker order and omitting markers that are not
found.
}
\examples{
\donttest{
library(qtl2)
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/main/DOex/DOex.zip")
DOex <- read_cross2(file)
DOex_rev <- cross2_to_grcm39(DOex)
}
}
\seealso{
\link{MUGAmaps}
}
