% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_table_cells.R
\name{replext_t1_c1}
\alias{replext_t1_c1}
\title{Replext Function for ANOVA Simulations in Table 1 Cell 1}
\usage{
replext_t1_c1(
  S = 20000,
  k = 3,
  fs = c(0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4),
  n_start = 6,
  constrs = c(0, 1, 2),
  alpha = 0.05,
  pow = 0.8,
  nmax = 1000
)
}
\arguments{
\item{S}{The number of datasets to generate for each simulation, default is 20000.}

\item{k}{The number of groups in the ANOVA design.}

\item{fs}{A vector of effect sizes to consider in the simulations.}

\item{n_start}{The starting sample size for the simulations.}

\item{constrs}{A vector of constraint types to be used in the simulations.}

\item{alpha}{The significance level used in hypothesis testing, default is 0.05.}

\item{pow}{The desired power for the statistical test, default is 0.80.}

\item{nmax}{The maximum sample size to consider in the simulations.}
}
\value{
A data frame containing the calculated Type I error rates and the minimum
sample sizes required for each combination of effect size and constraint type.
}
\description{
This function performs repeated simulations for ANOVA to determine minimum
sample sizes for given power and effect sizes, as well as calculating Type I error
rates. It is designed to replicate and extend the results for Table 1 Cell 1 in
Vanbrabant et al. (2015).
}
\details{
The function uses a nested approach, first determining minimum sample
sizes for various combinations of effect size and constraints, and then
calculating Type I error rates. It leverages the 'pj_pow' function for power
calculation and integrates internal function 'find_min_sample_size' for
determining the smallest sample size achieving the desired power.
}
\examples{
replext_t1_c1(S=5, fs = c(0.40), constrs = c(2))

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
