% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_all_members.R
\name{mnis_all_members}
\alias{mnis_all_members}
\title{Returns a tibble with information on al members of both houses or a given house.}
\usage{
mnis_all_members(house = "all", party = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{house}{The house to which the member belongs. Accepts one of 'all', 'lords' and 'commons', defaults to 'all'. This parameter is not case sensitive, so using 'commons', 'Commons' or 'cOmMOnS' will result in the same data being returned.}

\item{party}{The party to which a member belongs. Defaults to NULL, in which case all members are returned, subject to other parameters. The party names are not case sensitive, but must be the complete string of the party name, searching and wildcard options are not accepted by the API, e.g. 'green party'.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case"}
}
\value{
A tibble with information on all members of the House of Commons and/or the House of Lords that meet the criteria included in the function parameters.
}
\description{
Returns a tibble with information on al members of both houses or a given house.
}
\examples{
\dontrun{
x <- mnis_all_members(house = 'all', party = NULL, tidy = TRUE, tidy_style="snake_case")
}

}
\keyword{mnis}
