% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R, R/roc.coxph.R, R/roc.lrm.R
\name{roc}
\alias{roc}
\alias{roc.cph}
\alias{roc.coxph}
\alias{roc.glm}
\alias{roc.lrm}
\title{roc for model}
\usage{
roc(...)

\method{roc}{cph}(..., times = NULL, model = NULL, x = NULL, method = c("NNE", "KM"))

\method{roc}{coxph}(..., times = NULL, model = NULL, x = NULL, method = c("NNE", "KM"))

\method{roc}{glm}(
  ...,
  negref = 0,
  model = NULL,
  x = NULL,
  method = c("empirical", "binormal", "nonparametric")
)

\method{roc}{lrm}(
  ...,
  negref = 0,
  model = NULL,
  x = NULL,
  method = c("empirical", "binormal", "nonparametric")
)
}
\arguments{
\item{...}{one or more fit}

\item{times}{one or more times for cox regression}

\item{model}{can be logical or characters. FALSE means no model TP and FP,
characters mean model names.}

\item{x}{can be logical or characters. TRUE means all x variable in regression
will be calculated. One or more characters will be calculated only.}

\item{method}{NNE or KM}

\item{negref}{negative reference for each model}
}
\value{
roc dataframe

one roc_coxph for cox regression. model means model names,
}
\description{
roc for model
}
\references{
Heagerty PJ, Lumley T, Pepe MS. \emph{Time-dependent ROC curves
for censored survival data and a diagnostic marker.} Biometrics, 2000.

Pepe, Margaret Sullivan. \emph{The statistical evaluation
of medical tests for classification and prediction.} Medicine, 2003.

Zou, Kelly H., W. J. Hall, and David E. Shapiro.
\emph{Smooth non-parametric receiver operating characteristic (ROC)
curves for continuous diagnostic tests.} Statistics in medicine
16, no. 19 (1997): 2143-2156.
}
