% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MERS_2013_MEregion}
\alias{MERS_2013_MEregion}
\title{A dataset of MERS outbreaks in the Middle East region}
\format{
A data frame (\code{data.frame}) with 55 rows of records, and 3 columns of variables:
\describe{
\item{\code{obs.seed}}{Observations of the number of seed cases that generated the outbreak.}
\item{\code{obs.finalsize}}{Observations of final outbreak size generated by given numbers (given in \code{obs.seed}) of seed cases.}
\item{\code{type}}{A categorical variable takes the value "outbreaksize" indicating the type of observations.}
}
}
\usage{
MERS_2013_MEregion
}
\description{
This dataset (i.e., \code{MERS_2013_MEregion}) contains 55 observations of \strong{final outbreak size} generated by given numbers of seed cases,
which were collected in Middle East respiratory syndrome (MERS) outbreaks in the Middle East (ME) regions in 2013.
}
\examples{
data(MERS_2013_MEregion)
summary(MERS_2013_MEregion)

}
\references{
Poletto C, Pelat C, Levy-Bruhl D, Yazdanpanah Y, Boelle PY, Colizza V. Assessment of the Middle East respiratory syndrome coronavirus (MERS-CoV) epidemic in the Middle East and risk of international spread using a novel maximum likelihood analysis approach. \emph{Eurosurveillance}. 2014;19(23):20824.
\doi{10.2807/1560-7917.ES2014.19.23.20824}, see the "baseline" column in Table 1 for the raw data.

Kucharski AJ, Althaus CL. The role of superspreading in Middle East respiratory syndrome coronavirus (MERS-CoV) transmission. \emph{Eurosurveillance}. 2015;20(25):21167.
\doi{10.2807/1560-7917.ES2015.20.25.21167}
}
\keyword{datasets}
