% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-refit.R
\name{modeltime_refit}
\alias{modeltime_refit}
\title{Refit one or more trained models to new data}
\usage{
modeltime_refit(object, data, control = NULL, ...)
}
\arguments{
\item{object}{A Modeltime Table}

\item{data}{A \code{tibble} that contains data to retrain the model(s) using.}

\item{control}{Either \code{\link[=control_parsnip]{control_parsnip()}} or \code{\link[=control_workflow]{control_workflow()}} depending on the object.
If NULL, created automatically.}

\item{...}{Additional arguments passed to \code{\link[=fit]{fit()}}.}
}
\value{
A Modeltime Table containing one or more re-trained models.
}
\description{
This is a wrapper for \code{fit()} that takes a
Modeltime Table and retrains each model on \emph{new data} re-using the parameters
and preprocessing steps used during the training process.
}
\details{
Refitting is an important step prior to forecasting time series models.
The \code{modeltime_refit()} function makes it easy to recycle models,
retraining on new data.

\strong{Recycling Parameters}

Parameters are recycled during retraining using the following criteria:
\itemize{
\item \strong{Automated models} (e.g. "auto arima") will have parameters recalculated.
\item \strong{Non-automated models} (e.g. "arima") will have parameters preserved.
\item All preprocessing steps will be reused on the data
}

\strong{Refit}

The \code{modeltime_refit()} function is used to retrain models trained with \code{fit()}.

\strong{Refit XY}

The XY format is not supported at this time.
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

model_fit_auto_arima <- arima_reg() \%>\%
    set_engine(engine = "auto_arima") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_auto_arima
)

# ---- CALIBRATE ----
# - Calibrate on training data set

calibration_tbl <- models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits))


# ---- REFIT ----
# - Refit on full data set

refit_tbl <- calibration_tbl \%>\%
    modeltime_refit(m750)


}
