% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{legacy}
\alias{legacy}
\title{Monotone Regression Legacy Function}
\usage{
legacy(x, w = rep(1, length(x)), number = 0)
}
\arguments{
\item{x}{a real-valued vector.}

\item{w}{a real-valued vector with positive weights (default a vector with ones).}

\item{number}{function number (specifications below).}
}
\value{
Returns a real-valued vector with values of \code{x} in increasing order.
}
\description{
\code{legacy} provides some functions for monotone regression from the past.
Current implementations have been translated into C for proper comparison in Busing (2020).
}
\details{
Legacy implementations by number, function, author, and year:
\itemize{
 \item{0 = default (do nothing, sorry)}  
 \item{1 = fitm() by Kruskal}{ (1964).}
 \item{2 = wmrmnh() by van Waning}{ (1976).}
 \item{3 = amalgm() by Cran}{ (1980).}
 \item{4 = pav() by Bril}{ (1984).}
 \item{5 = isoreg() by Gupta}{ (1995).}
 \item{6 = iso_pava() by Turner}{ (1997).}
 \item{7 = isotonic() by Kincaid}{ (2001).}
 \item{8 = isomean() by Strimmer}{ (2008).}
 \item{9 = pooled_pava() by Pedregosa}{ (2011).}
 \item{10 = linear_pava() by Tulloch}{ (2014).}
 \item{11 = inplace_pava() by Varoquaux}{ (2016).}
 \item{12 = md_pava() by Danish}{ (2016).}
 \item{13 = reg_1d_l2() by Xu (2017).}
 \item{14 = jbkpava() by de Leeuw}{ (2017).}
}

Error checking on \code{w} or \code{x} is not present.
}
\examples{
y <- c( 8, 4, 8, 2, 2, 0, 8 )
x <- legacy( y, number = 1 )
print( x )

}
\references{
Busing, F.M.T.A. (2021).
  Monotone Regression: A Simple and Fast O(n) PAVA Implementation.
  Leiden University.
  ... and the references therein.
}
