% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largest_eafdiff.R
\name{choose_eafdiff}
\alias{choose_eafdiff}
\title{Interactively choose according to empirical attainment function differences}
\usage{
choose_eafdiff(x, left = stop("'left' must be either TRUE or FALSE"))
}
\arguments{
\item{x}{\code{matrix()}\cr Matrix of rectangles representing EAF differences
returned by \code{\link[=eafdiff]{eafdiff()}} with \code{rectangles=TRUE}.}

\item{left}{\code{logical(1)}\cr With \code{left=TRUE} return the rectangles with
positive differences, otherwise return those with negative differences but
differences are converted to positive.}
}
\value{
\code{matrix()} where the first 4 columns give the coordinates of two
corners of each rectangle and the last column. In both cases, the last
column gives the positive differences in favor of the chosen side.
}
\description{
Interactively choose according to empirical attainment function differences
}
\examples{
\donttest{
extdata_dir <- system.file(package="moocore", "extdata")
A1 <- read_datasets(file.path(extdata_dir, "wrots_l100w10_dat"))
A2 <- read_datasets(file.path(extdata_dir, "wrots_l10w100_dat"))
# Choose A1
rectangles <- eafdiff(A1, A2, intervals = 5, rectangles = TRUE)
rectangles <- choose_eafdiff(rectangles, left = TRUE)
reference <- c(max(A1[, 1], A2[, 1]), max(A1[, 2], A2[, 2]))
x <- split.data.frame(A1[,1:2], A1[,3])
hv_A1 <- sapply(split.data.frame(A1[, 1:2], A1[, 3]),
                 hypervolume, reference=reference)
hv_A2 <- sapply(split.data.frame(A2[, 1:2], A2[, 3]),
                 hypervolume, reference=reference)
print(fivenum(hv_A1))
print(fivenum(hv_A2))
whv_A1 <- sapply(split.data.frame(A1[, 1:2], A1[, 3]),
                 whv_rect, rectangles=rectangles, reference=reference)
whv_A2 <- sapply(split.data.frame(A2[, 1:2], A2[, 3]),
                 whv_rect, rectangles=rectangles, reference=reference)
print(fivenum(whv_A1))
print(fivenum(whv_A2))
}

}
\concept{eaf}
