% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFx.survFit.R
\name{MFx.survFit}
\alias{MFx.survFit}
\title{Predict x\% Multiplication Factor at any specified time point for 
a \code{survFit} object.}
\usage{
\method{MFx}{survFit}(object, data_predict, X = 50, time_MFx = NULL,
  MFx_range = c(0, 1000), mcmc_size = 1000, hb_value = TRUE,
  spaghetti = FALSE, accuracy = 0.01, quiet = FALSE,
  threshold_iter = 100, ...)
}
\arguments{
\item{object}{An object of class \code{survFit}.}

\item{data_predict}{A dataframe with two columns \code{time} and \code{conc}.}

\item{X}{Percentage of survival change (e.g., \eqn{50} for survival decrease of 50\%
, or \eqn{-50} for survival increase of 50\%).The default is 50. 
Only time series computed during the adaptation using a binary search in
\eqn{O(log(n))} are returned. However, if \code{NULL}, all time series
computed from the vector \code{MFx_range} are returned.}

\item{time_MFx}{A number giving the time at which  \eqn{MF(x,t)} has to be estimated. 
If NULL, the latest time point of the profile is used.}

\item{MFx_range}{A vector from which lower and upper bound of the range of the
 multiplication factor \code{MFx} are generated. The default is a vector \code{c(0, 1000)}.
If argument \code{X} is \code{NULL}, then all the time series generated with
\code{MFx_range} are returned.}

\item{mcmc_size}{Can be used to reduce the number of MCMC samples in order to speed up
the computation. The default is 1000.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into
 account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{accuracy}{Accuracy of the multiplication factor. The default is 0.01.}

\item{quiet}{If \code{FALSE}, print the evolution of accuracy.}

\item{threshold_iter}{Threshold number of iteration.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns an object of class \code{MFx}, which is a list
 with the following information:
 \item{X_prop}{Survival probability for \code{X} percent of reduction of the initial median 
survival probability at time \code{time_MFx}.}
\item{X_prop_provided}{A number giving the proportion of reduction in survival.}
\item{time_MFx}{A number giving the time at which  \eqn{MF(x,t)} has to be
 estimated as provided in arguments or if NULL, the latest time point of the
  profile is used.}
\item{df_MFx}{A \code{data.frame} with quantiles (median, 2.5\% and 97.5\%)
 of \eqn{MF(x,t)} at time \eqn{t}, \code{time_MFx}, for \eqn{x}\% of survival reduction.}
\item{df_dose}{A \code{data.frame} with quantiles (median, 2.5\% and 97.5\%)
 of survival probability along the computed multiplication factor and at time \code{time_MFx}.}
\item{MFx_tested}{A vector of all multiplication factors computed.} 
\item{ls_predict}{A list of all object of class \code{survFitPredict} obtained
from computing survival probability for every profiles build from the vector of
multiplication factors \code{MFx_tested}.}
}
\description{
The function \code{MFx}, \eqn{x}\% Multiplication Factor at time \eqn{t}, (\eqn{MF(x,t)}),
is used to compute the multiplication factor
applied to the concentration exposure profile in order to
reduce by \eqn{x}\% (argument \code{X}) the survival probability at a
 specified test duration \eqn{t} (argument \code{time_MFx}) (default is the maximum
 time point of the experiment).
 
 Mathematical definition of \eqn{x}\% Multiplication Factor at time \eqn{t}
 (at the end of a time series \eqn{T = \{0, \dots, t\}}),
 denoted \eqn{MF(x,t)}, is given by:
 
 \eqn{S(MF(x,t) * C_w(\tau \in T), t) = S( C_w(\tau \in T), t)*(1- x/100)},
 
 where \eqn{C_w(\tau \in T)} is the initial exposure profile without
 multiplication factor. And so the expression \eqn{S(MF(x,t)* C_w(\tau \in T), t)}
  is the survival probability after an exposure profile
   \eqn{MF(x,t)* C_w(\tau \in T)} at time \eqn{t}.
}
\examples{

# (1) Load the data
data("propiconazole")

# (2) Create an object of class 'survData'
dataset <- survData(propiconazole)

\dontrun{
# (3) Run the survFit function with model_type SD (or IT)
out_SD <- survFit(dataset, model_type = "SD")

# (4) data to predict
data_4prediction <- data.frame(time = 1:10, conc = c(0,0.5,3,3,0,0,0.5,3,1.5,0))

# (5) estimate MF(x=30, t=4), that is for 30\% reduction of survival at time 4
MFx_SD_30.4 <- MFx(out_SD, data_predict = data_4prediction , X = 30, time_MFx = 4)

# (5bis) estimate MF(x,t) along the MF_range from 5 to 10 (50) (X = NULL)
MFx_SD_range <- MFx(out_SD, data_predict = data_4prediction ,
                    X = NULL, time_MFx = 4, MFx_range = seq(5, 10, length.out = 50))
}


}
