% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitCstExp.R
\name{ppc.survFitCstExp}
\alias{ppc.survFitCstExp}
\title{Posterior predictive check plot for \code{survFitCstExp} objects}
\usage{
\method{ppc}{survFitCstExp}(x, style = "ggplot", main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survFitCstExp}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{main}{main title for the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{ppc} S3 method for the \code{survFitCstExp} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFit} objects.
}
\details{
The black points show the observed number of survivors (pooled
replicates, on \eqn{X}-axis) against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise. Samples with equal observed
value are shifted on the \eqn{X}-axis. For that reason, the
bisecting line (y = x), is represented by steps when observed
values are low. That way we ensure green intervals do intersect the
bisecting line.
}
\examples{

# (1) Load the data
data(propiconazole)

# (2) Create an object of class "survData"
dataset <- survData(propiconazole)

\dontrun{
# (3) Run the survFitTKTD function with the TKTD model ('SD' or 'IT')
out <- survFit(dataset, model_type = "SD")

# (4) Plot observed versus predicted values
ppc(out)
}

}
