% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot.R
\name{mplot}
\alias{mplot}
\alias{mplot.default}
\alias{mplot.lm}
\alias{mplot.data.frame}
\alias{mplot.summary.lm}
\alias{mplot.TukeyHSD}
\title{Generic plotting}
\usage{
mplot(object, ...)

\method{mplot}{default}(object, ...)

\method{mplot}{lm}(object, which = c(1:3, 7), system = c("ggplot2",
  "lattice", "base"), ask = FALSE, multiplot = "package:gridExtra" \%in\%
  search(), par.settings = theme.mosaic(), level = 0.95,
  title = paste("model: ", deparse(object$call), "\\n"), rows = TRUE,
  id.n = 3L, id.size = 6, id.color = "red", id.nudge = 1, ...)

\method{mplot}{data.frame}(object, format, default = format,
  system = c("ggformula", "ggplot2", "lattice"), show = FALSE, title = "",
  ...)

\method{mplot}{summary.lm}(object, system = c("ggplot2", "lattice"),
  level = 0.95, par.settings = trellis.par.get(), rows = TRUE, ...)

\method{mplot}{TukeyHSD}(object, system = c("ggplot2", "lattice"),
  ylab = "", xlab = "difference in means", title = paste0(attr(object,
  "conf.level") * 100, "\% family-wise confidence level"),
  par.settings = trellis.par.get(), order = c("asis", "pval", "difference"),
  ...)
}
\arguments{
\item{object}{an R object from which a plot will be constructed.}

\item{...}{additional arguments.  If \code{object} is an \code{lm}, subsets
of these arguments are passed to \code{grid.arrange} and to the
\pkg{lattice} plotting routines; in particular,
\code{nrow} and \code{ncol} can be used to control the number of rows
and columns used.}

\item{which}{a numeric vector used to select from 7 potential plots}

\item{system}{which graphics system to use (initially) for plotting (\pkg{ggplot2}
or \pkg{lattice}).  A check box will allow on the fly change of plotting system.}

\item{ask}{if TRUE, each plot will be displayed separately after the user
responds to a prompt.}

\item{multiplot}{if TRUE and \code{ask == FALSE}, all plots will be
displayed together.}

\item{par.settings}{\pkg{lattice} theme settings}

\item{level}{a confidence level}

\item{title}{title for plot}

\item{rows}{rows to show.  This may be a numeric vector,
\code{TRUE} (for all rows), or a character vector of row names.}

\item{id.n}{Number of id labels to display.}

\item{id.size}{Size of id labels.}

\item{id.color}{Color of id labels.}

\item{id.nudge}{a numeric used to increase (>1) or decrease (<1) the amount that observation labels are
nudged.  Use a negative value to nudge down instead of up.}

\item{format, default}{default type of plot to create; one of
\code{"scatter"},
\code{"jitter"},
\code{"boxplot"},
\code{"violin"},
\code{"histogram"},
\code{"density"},
\code{"frequency polygon"},
or
\code{"map"}.
Unique prefixes suffice.}

\item{show}{a logical, if \code{TRUE}, the code will be displayed each time the plot is
changed.}

\item{ylab}{label for y-axis}

\item{xlab}{label for x-axis}

\item{order}{one of \code{"pval"}, \code{"diff"}, or \code{"asis"} determining the
order of the \code{pair} factor, which determines the order in which the differences
are displayed on the plot.}

\item{data}{a data frame containing the variables that might be used in the plot.}
}
\value{
Nothing.  Just for side effects.
}
\description{
Generic function plotting for R objects.  Currently plots exist for
\code{data.frame}s, \code{lm}s, (including \code{glm}s).
}
\details{
The method for models (lm and glm) is still a work in progress, but should be usable for
relatively simple models.  When the results for a logistic regression model created with
\code{\link[=glm]{glm()}} are satisfactory will depend on the format and structure of the data
used to fit the model.
}
\examples{
mplot( lm( width ~ length * sex, data = KidsFeet) )
mplot( lm( width ~ length * sex, data = KidsFeet), rows = 2:3, which = 7 )
\dontrun{
mplot( HELPrct )
mplot( HELPrct, "histogram" )
}
mplot(summary(lm(width ~ length * sex, data = KidsFeet)), system = "ggplot2")
mplot(summary(lm(width ~ length * sex, data = KidsFeet)), rows = c("sex", "length"))
mplot(summary(lm(width ~ length * sex, data = KidsFeet)), rows = TRUE)
mplot(TukeyHSD( lm(age ~ substance, data = HELPrct) ) )
mplot(TukeyHSD( lm(age ~ substance, data = HELPrct) ), system = "ggplot2" )
}
