% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecrshims.R
\name{combine.operators}
\alias{combine.operators}
\title{Combine ECR-Operators}
\usage{
combine.operators(param.set, ..., .binary.discrete.as.logical = TRUE)
}
\arguments{
\item{param.set}{\verb{[ParamSet]} \code{\link[ParamHelpers:makeParamSet]{ParamSet}} that defines the search space.}

\item{...}{additional parameters. See description.}

\item{.binary.discrete.as.logical}{\verb{[logical(1)]} whether to treat binary discrete parameters as \code{logical} parameters and
use bitwise operators.}
}
\value{
\code{\link[ecr:makeOperator]{ecr_operator}} ecr operator.
}
\description{
Combine operators to be applied to individuals that conform to parameter set \code{param.set}.
Parameters are the \code{param.set}, and the names / types of params with the operator to use.
Parameter groups that use a single operator can be defined using \verb{.params.<groupname> = [character]}.

Say \code{param.set} has three logical params 'l1', 'l2', 'l3' and two numeric params 'n1', 'n2'.
To use operatorA for 'l1' and 'l2', operatorB for 'l3', and operatorC for all numeric
params, call
\code{combineOperator(param.set, .params.group1 = c("l1", "l2"), group1 = operatorA, l3 = operatorB, numeric = operatorC)}.

Use arguments by types, names of parameters, or group name. Valid types are 'numeric', 'logical', 'integer', 'discrete'.
Operators given for groups or individual parameters supercede operators given for types.

Strategy parameters can be created by using \verb{.strategy.<groupname|parametername|type>}. They must be a \emph{function}
taking a named list of parameter values (i.e. an individuum) as input and return a named list of parameter values
to be given to the respective group's / parameter's or type's operator. If, in the example above, \code{operatorA} has
a parameter \code{sigma} that should also be treated as a parameter under evolution (and in fact be equal to \code{l3}), then
the above call would become
\code{combineOperator(param.set, .params.group1 = c("l1", "l2"), group1 = operatorA, .strategy.group1 = function(x) list(sigma = x$l3), l3 = operatorB, numeric = operatorC)}.

If .binary.discrete.as.logical is TRUE, then binary discrete params are handled as logical params.

Operators for logical parameters must have only one argument. Operators for discrete parameters
must have an additional argument 'values'. Operators for continuous or integer parameters must have
an additional argument 'lower', 'upper'.

Use the ecr::setup function to set parameters for operators ("currying").
}
\examples{
library(mlrCPO)

# Create parameter set 
ps <- pSS(
logi: logical, 
disc: discrete[yes, no], 
discvec: discrete[letters]^3, 
numer: numeric[0, 10])

# Define mutators for groups of parameters 
combo.mut <- combine.operators(ps, 
.params.group1 = c("logi", "disc"), # define group for which same mutator is used
group1 = ecr::setup(mutBitflip, p = 1), # set probability for mutation to 1
discrete = mutRandomChoice, # define operator for all other discrete parameters
numer = mutGauss) # specific operator for parameter numer

combo.mut(list(logi = FALSE, disc = "yes", discvec = c("a", "x", "y"), 
numer = 2.5))

# Define mutator with strategy parameter
combo.strategy <- combine.operators(ps,
logical = ecr::setup(mutBitflip, p = 0),
discrete = mutRandomChoice,
numeric = mutGauss, 
.strategy.numeric = function(ind) {
if (ind$disc == "yes") {
return(list(p = 1L))
} else {
return(list(p = 0L))
}
})

combo.strategy(list(logi = FALSE, disc = "no", discvec = c("a", "x", "y"), 
numer = 2.5))

# Define recombinators for groups of parameters
combo.rec <- combine.operators(ps, 
.params.group1 = c("logi", "disc"), # define group for which same mutator is used
group1 = recPCrossover, 
discrete = recPCrossover,
numer = recGaussian)

combo.rec(list(list(logi = FALSE, disc = "no", discvec = c("a", "x", "y"), 
numer = 2.5), list(logi = TRUE, disc = "yes", discvec = c("c", "e", "g"), 
numer = 7.5)))

}
