% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customnsga2.R
\name{slickEcr}
\alias{slickEcr}
\alias{initEcr}
\alias{continueEcr}
\title{Modified Interface to ECR}
\usage{
slickEcr(
  fitness.fun,
  lambda,
  population,
  mutator,
  recombinator,
  generations = 100,
  parent.selector = selSimple,
  survival.selector = selNondom,
  p.recomb = 0.7,
  p.mut = 0.3,
  survival.strategy = "plus",
  n.elite = 0,
  fidelity = NULL,
  unbiased.fidelity = TRUE,
  log.stats = NULL,
  log.stats.newinds = c(list(runtime = list("mean", "sum")), if (!is.null(fidelity))
    list(fidelity = list("sum")))
)

initEcr(
  fitness.fun,
  population,
  fidelity = NULL,
  log.stats = NULL,
  log.stats.newinds = c(list(runtime = list("mean", "sum")), if (!is.null(fidelity))
    list(fidelity = list("sum"))),
  unbiased.fidelity = TRUE
)

continueEcr(
  ecr.object,
  generations,
  lambda = NULL,
  mutator = NULL,
  recombinator = NULL,
  parent.selector = NULL,
  survival.selector = NULL,
  p.recomb = NULL,
  p.mut = NULL,
  survival.strategy = NULL,
  n.elite = NULL,
  fidelity = NULL,
  unbiased.fidelity = NULL
)
}
\arguments{
\item{fitness.fun}{\verb{[smoof_multi_objective_function]} fitness function, must be a
"\code{smoof}" function.}

\item{lambda}{\verb{[integer(1)]} number of individuals to add in each generation.}

\item{population}{\verb{[list]} list of individuals to start off from.}

\item{mutator}{\verb{[ecr_mutator]} mutation operator.}

\item{recombinator}{\verb{[ecr_recombinator]} recombination operator.}

\item{generations}{\verb{[integer(1) | list of function]} number of iterations to
evaluate if it is an integer, or \link[=mosmafsTermEvals]{terminator} function.
If this is an integer, it counts the \emph{new} generations to evaluate;
otherwise the terminator functions are applied to the whole combined trace
of evaluation.}

\item{parent.selector}{\verb{[ecr_selector]} parent selection operator.}

\item{survival.selector}{\verb{[ecr_selector]} survival selection operator.}

\item{p.recomb}{\verb{[numeric(1)]} probability to apply a recombination operator.}

\item{p.mut}{\verb{[numeric(1)]} probability to apply mutation operator.}

\item{survival.strategy}{\verb{[character(1)|function]} one of \code{"plus"} or \code{"comma"}
or a function. If function, arguments must be the same as for
\code{\link[ecr:replaceMuPlusLambda]{ecr::replaceMuPlusLambda}}.}

\item{n.elite}{\verb{[integer(1)]} Number of elites to keep, only used if
\code{survival.strategy} is \code{"comma"}}

\item{fidelity}{\verb{[data.frame | NULL]} If this is given, it controls the
fidelity of the function being evaluated, via its \code{fidelity} argument.
It must then be a \code{data.frame} with two or three columns. The first column
gives the generation at which the fidelity first applies; the second
column controls the fidelity at that generation or later; the third column,
if given, controls the additional fidelity whenever the result of the first
evaluation is not dominated by any result of the previous generation. The
entries in the first column must be strictly ascending. The first element
of the first column must always be 1. Whenever fidelity changes, the whole
population is re-evaluated, so it is recommended to use only few different
fidelity jumps throughout all generations.}

\item{unbiased.fidelity}{\verb{[logical(1)]} Whether generations do not have to be re-evaluated when fidelity jumps downward.}

\item{log.stats}{\verb{[list]} information to log for each generation. Defaults to
min, mean, and max of each objective as well as dominated hypervolume.}

\item{log.stats.newinds}{\verb{[list]} information to log for each newly evaluated individuals}

\item{ecr.object}{\verb{[MosmafsResult]} an object retrieved from previous runs of
\code{initEcr}, \code{slickEcr}, or \code{continueEcr}}
}
\value{
\verb{[MosmafsResult]} the terminated optimization state.
}
\description{
Mostly \code{\link[ecr:ecr]{ecr::ecr}}, with some simplifications and extensions.

\code{slickEcr} does mostly what \code{ecr::ecr} does, with different default values at places.
Note that \code{fitness.fun} must be a "\code{\link[smoof:smoof-package]{smoof}}" function.

\code{initEcr} only evaluates fitness for the initial population and does not perform any
mutation or selection.

\code{continueEcr} continues a run for another number of \code{generations}. Only \code{ecr.object}
(a result from a previous \code{initEcr}, \code{slickEcr}, or \code{continueEcr} call) and
\code{generations} must be given, the other arguments are optional. \emph{If} they were set
in a previous \code{slickEcr} or \code{continueEcr} call, the values from the
previous run are used. Otherwise it is possible to supply any combination of these values
to set them to new values.

Note, for \code{fidelity}, that the generation continues counting from previous runs,
so if \code{initEcr} was ran for 5 generations and \code{continueEcr} is called with
a \code{fidelity} with first column values \code{c(1, 8)}, then the fidelity given in the
first row is applied for 2 generations, after which the fidelity given in the
second row applies.
}
\examples{
\donttest{
library("mlr")
library("magrittr")
library("mlrCPO")

# Define tasks
task.whole <- create.hypersphere.data(3, 2000) \%>\%
create.classif.task(id = "sphere") \%>\%
task.add.permuted.cols(10)
rows.whole <- sample(2000)
task <- subsetTask(task.whole, rows.whole[1:500])
task.hout <- subsetTask(task.whole, rows.whole[501:2000])

# Create learner
lrn <- makeLearner("classif.rpart", maxsurrogate = 0)

# Create parameter set to optimize over
ps <- pSS(
 maxdepth: integer[1, 30],
 minsplit: integer[2, 30],
 cp: numeric[0.001, 0.999])

# Create fitness function
fitness.fun <- makeObjective(lrn, task, ps, cv5,
 holdout.data = task.hout)
 
#  Receive parameter set from fitness function
ps.objective <- getParamSet(fitness.fun)

# Define mutators and recombinators
mutator <- combine.operators(ps.objective,
 numeric = ecr::setup(mutGauss, sdev = 0.1),
 integer = ecr::setup(mutGaussInt, sdev = 3),
 selector.selection = mutBitflipCHW)
crossover <- combine.operators(ps.objective,
 numeric = recPCrossover,
 integer = recPCrossover,
 selector.selection = recPCrossover)

# Initialize population and evaluate it
initials <- sampleValues(ps.objective, 32, discrete.names = TRUE)
run.init <- initEcr(fitness.fun = fitness.fun, population = initials)

# Run NSGA-II for 5 generations with run.init as input
run.gen <- continueEcr(run.init, generations = 5, lambda = 5, mutator = mutator, 
 recombinator = crossover, parent.selector = selSimple, 
 survival.selector = selNondom, 
 p.recomb = 0.7, p.mut = 0.3, survival.strategy = "plus")
 
# Or instead of initEcr and continueEcr use the shortcut function slickEcr
run.simple <- slickEcr(
 fitness.fun = fitness.fun, lambda = 5, population = initials,
 mutator = mutator,
 recombinator = crossover,
 generations = 5)
 
print(run.simple)
} 
}
