% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{initSelector}
\alias{initSelector}
\title{Initialize Selector}
\usage{
initSelector(
  individuals,
  vector.name = "selector.selection",
  distribution = function() floor(runif(1, 0, length(individuals[[1]][[vector.name]]) +
    1)),
  soften.op = NULL,
  soften.op.strategy = NULL,
  soften.op.repeat = 1,
  reject.condition = function(x) !any(x)
)
}
\arguments{
\item{individuals}{\verb{[list of named lists]} the individuals to initialize.}

\item{vector.name}{\verb{[character(1)]} the variable name, whose entries are
sampled.}

\item{distribution}{\verb{[function]} function that returns a random integer
from 0 to the length of each individual's \code{vector.name} slot.
Defaults to the uniform distribution from 1 to \code{length()}.}

\item{soften.op}{\verb{[ecr_mutator]} an optional mutator to apply to the
\code{vector.name} variable.}

\item{soften.op.strategy}{\code{function} an optional function that can set
the \code{soften.op}'s parameters. See \code{\link{combine.operators}} strategy parameters.
Ignored if \code{soften.op} is not given.}

\item{soften.op.repeat}{\verb{[integer(1)]} how often to repeat \code{soften.op}
application. Ignored if \code{soften.op} is not given.}

\item{reject.condition}{\verb{[function | NULL]} reject condition as a function applied
to newly generated values of \code{vector.name}. If set to NULL, no rejection is done.}
}
\value{
\verb{list of named lists} the individuals with initialized
\verb{[[vector.name]]}.
}
\description{
Sample the \code{vector.name} variable such that the number of ones
has a given distribution.
}
\examples{
library(mlrCPO)

# Initialize parameter set and sample candidates
ps <- pSS(
 maxdepth: integer[1, 30],
 minsplit: integer[2, 30],
 cp: numeric[0.001, 0.999], 
 selector.selection: logical^5)

initials <- sampleValues(ps, 15, discrete.names = TRUE)

# Resample logical vector selector.selection of initials 
# with binomial distribution 
initSelector(initials, distribution = function() rbinom(n = 5, size = 5, 
 prob = 0.5))

}
