% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exhaust_bic}
\alias{exhaust_bic}
\title{Algorithm II (Local change-point search with sBIC)}
\usage{
exhaust_bic(cand, sub_sums, strength, log_penalty, n, auc, min_cost)
}
\description{
Input cand: =mathcal D, conflicting changepoints candidate set
Input sub_sums: Pre-computed partial sums, as obtained by extract_sub
Input strength: Exponent for penalty
Input log_penalty: log (or polynomial) penalty term?
Input n: Overall length of data
Input auc: =|mathcal C|, total number of currently active changepoints 
      (+candidates)
Input min_cost: Minimal RSS with all the candidates
}
\details{
Output bic: (Mx2) matrix (M=2^m with m=|cand|) containing RSS/cost and sBIC
        terms for all combinations within cand. Combinations are indexed
        by their implicit integer representation, i.e. bic[0,] corresponds
        to the empty set, bic[3,] to {k_1,k_2} [0..011], etc.
        Note: Row May be Inf, if combination was not visited in algorithm.
Output est_cpts: Integer Vector of estimated changepoints
Output final: Bool Vector indicating if combinations are final states
Output num_cpts: For debugging purposes
}
\keyword{internal}
